/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtilities {
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};

    public static void setLocalTimeZone(TimeZone tz) {
        DateFormat defaultFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        defaultFormat.setTimeZone(tz);
    }

    public static Date round(Date date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        GregorianCalendar gval = new GregorianCalendar();
        gval.setTime(date);
        DateUtilities.modify(gval, field, true);
        return gval.getTime();
    }

    public static Calendar round(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar rounded = (Calendar)date.clone();
        DateUtilities.modify(rounded, field, true);
        return rounded;
    }

    public static Date truncate(Date date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        GregorianCalendar gval = new GregorianCalendar();
        gval.setTime(date);
        DateUtilities.modify(gval, field, false);
        return gval.getTime();
    }

    public static Calendar truncate(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar truncated = (Calendar)date.clone();
        DateUtilities.modify(truncated, field, false);
        return truncated;
    }

    public static String formatDate(long time) {
        DateFormat defaultFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        return DateUtilities.formatDate(time, (Format)defaultFormat);
    }

    public static String formatDate(long time, Format format) {
        if (time == 0L) {
            return "";
        }
        Date d = new Date(time);
        return format.format(d);
    }

    public static String formatDate(Date date) {
        DateFormat defaultFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        return DateUtilities.formatDate(date, (Format)defaultFormat);
    }

    public static String formatDate(Date date, Format format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    private static void modify(Calendar val, int field, boolean round) {
        boolean roundUp = false;
        for (int i = 0; i < fields.length; ++i) {
            for (int j = 0; j < fields[i].length; ++j) {
                if (fields[i][j] != field) continue;
                if (round && roundUp) {
                    if (field == 1001) {
                        if (val.get(5) == 1) {
                            val.add(5, 15);
                        } else {
                            val.add(5, -15);
                            val.add(2, 1);
                        }
                    } else {
                        val.add(fields[i][0], 1);
                    }
                }
                return;
            }
            int offset = 0;
            boolean offsetSet = false;
            switch (field) {
                case 1001: {
                    if (fields[i][0] != 5) break;
                    offset = val.get(5) - 1;
                    if (offset >= 15) {
                        offset -= 15;
                    }
                    roundUp = offset > 7;
                    offsetSet = true;
                    break;
                }
                case 9: {
                    if (fields[i][0] != 10) break;
                    offset = val.get(10);
                    if (offset >= 12) {
                        offset -= 12;
                    }
                    roundUp = offset > 6;
                    offsetSet = true;
                    break;
                }
            }
            if (!offsetSet) {
                int min = val.getActualMinimum(fields[i][0]);
                int max = val.getActualMaximum(fields[i][0]);
                offset = val.get(fields[i][0]) - min;
                roundUp = offset > (max - min) / 2;
            }
            val.add(fields[i][0], -offset);
        }
        throw new IllegalArgumentException("The field " + field + " is not supported");
    }

    public static long getFirstDateOfWeek(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        int dayOfWeek = cal.get(7);
        cal.setTimeInMillis(date - (long)((dayOfWeek - 1) * 24) * 3600000L);
        return cal.getTimeInMillis();
    }

    public static String getDayTime(long date) {
        String dateTime = "";
        try {
            Date d = new Date();
            d.setTime(date);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            dateTime = fmt.format(d);
        }
        catch (Exception e) {
            dateTime = "UNKNOWN";
        }
        return dateTime;
    }

    public static String getDayHourTime(long date) {
        String dateTime = "";
        try {
            Date d = new Date();
            d.setTime(date);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd h aa", new Locale("en", "US"));
            dateTime = fmt.format(d);
        }
        catch (Exception e) {
            dateTime = "UNKNOWN";
        }
        return dateTime;
    }

    public static String getDateTime(long date) {
        String dateTime = "";
        try {
            Date d = new Date();
            d.setTime(date);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateTime = fmt.format(d);
        }
        catch (Exception e) {
            dateTime = "UNKNOWN";
        }
        return dateTime;
    }

    public static boolean isDateExpired(long date) {
        Date d = new Date(date);
        return new Date().after(d);
    }

    public static long getIntervalToThisMidnight() {
        long retValue = 0L;
        long now = System.currentTimeMillis();
        Calendar currentCalender = Calendar.getInstance();
        currentCalender.setTimeInMillis(now);
        Calendar nextDayCalender = Calendar.getInstance();
        nextDayCalender.setTimeInMillis(now);
        nextDayCalender.set(11, 23);
        nextDayCalender.set(12, 59);
        nextDayCalender.set(13, 59);
        nextDayCalender.set(14, 999);
        retValue = nextDayCalender.getTimeInMillis() - currentCalender.getTimeInMillis() + 1L;
        return retValue < 0L ? 0L : retValue;
    }

    public static Calendar getSameDayOfNextMonth(Calendar lastDate, int day) {
        Calendar scheduledDate = Calendar.getInstance();
        scheduledDate.set(1, lastDate.get(1));
        scheduledDate.set(2, lastDate.get(2) + 1);
        scheduledDate.set(5, 1);
        scheduledDate.set(11, lastDate.get(11));
        scheduledDate.set(12, lastDate.get(12));
        scheduledDate.set(13, lastDate.get(13));
        int maxDayOfTheMonth = scheduledDate.getActualMaximum(5);
        if (day > maxDayOfTheMonth) {
            day = maxDayOfTheMonth;
        }
        scheduledDate.set(5, day);
        return scheduledDate;
    }

    public static Boolean compareDate(String firstdate, String secDate) {
        Calendar firstDateCal = Calendar.getInstance();
        Calendar secDateCal = Calendar.getInstance();
        firstDateCal.set(Integer.parseInt(firstdate.substring(0, 4)), Integer.parseInt(firstdate.substring(5, 7)) - 1, Integer.parseInt(firstdate.substring(8, 10)));
        secDateCal.set(Integer.parseInt(secDate.substring(0, 4)), Integer.parseInt(secDate.substring(5, 7)) - 1, Integer.parseInt(secDate.substring(8, 10)));
        return firstDateCal.after(secDateCal);
    }

    public static long getGregorianDateTime(long timeStampBuddhish) throws Exception {
        long timeStampGregorian = timeStampBuddhish;
        int offsetStandard = 500;
        int offBetweenGreBud = 543;
        try {
            GregorianCalendar gmtCalCurrent = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            GregorianCalendar gmtCalBuddh = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            gmtCalBuddh.setTimeInMillis(timeStampBuddhish);
            int gmtYearCurrent = gmtCalCurrent.get(1);
            int gmtYearCompared = gmtCalBuddh.get(1);
            if (gmtYearCompared - gmtYearCurrent >= offsetStandard) {
                gmtCalBuddh.set(1, gmtYearCompared - offBetweenGreBud);
            } else if (gmtYearCurrent - gmtYearCompared >= offsetStandard) {
                gmtCalBuddh.set(1, gmtYearCompared + offBetweenGreBud);
            }
            timeStampGregorian = gmtCalBuddh.getTimeInMillis();
        }
        catch (Exception e) {
            timeStampGregorian = timeStampBuddhish;
            throw e;
        }
        return timeStampGregorian;
    }

    public static String convertToDateTimeStr(String timeStamp) {
        String strDateTime = null;
        SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        m_sdf.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT")));
        try {
            long l = Long.parseLong(timeStamp);
            strDateTime = m_sdf.format(new Date(l));
        }
        catch (NumberFormatException nfe) {
            strDateTime = timeStamp;
        }
        return strDateTime;
    }
}

