/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabaseUtilities {
    public static String getInClauses(String columnName, Collection<String> ids) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(ids);
        int size = list.size();
        int subCount = 0;
        int groupCount = 0;
        for (int i = 0; i < size; ++i) {
            if (subCount == 0) {
                if (groupCount == 0) {
                    buffer.append(" IN (");
                } else {
                    buffer.append(" OR ");
                    buffer.append(columnName);
                    buffer.append(" IN (");
                }
            }
            if (subCount > 0) {
                buffer.append(",");
            }
            buffer.append("'" + (String)list.get(i) + "'");
            if (subCount == 199) {
                buffer.append(") ");
                subCount = 0;
                ++groupCount;
                continue;
            }
            ++subCount;
        }
        if (subCount != 0) {
            buffer.append(") ");
        }
        return buffer.toString();
    }

    public static String translateSQLToHSQL(String sqlStr) {
        if (StringUtilities.isEmpty(sqlStr)) {
            return "";
        }
        if (!(sqlStr = sqlStr.toUpperCase()).startsWith("CREATE VIEW")) {
            String onClause;
            int index;
            sqlStr = sqlStr.replaceAll(" IMAGE ", " BINARY ");
            Matcher matcher = Pattern.compile("(\\s+)(NVARCHAR)(\\s*)(\\()(\\d+)(\\s*)(\\))", 10).matcher(sqlStr);
            sqlStr = matcher.replaceAll("$1VARCHAR$3$4$5$6$7");
            sqlStr = sqlStr.replaceAll(" NONCLUSTERED ", " ");
            sqlStr = sqlStr.replaceAll(" CLUSTERED ", " ");
            sqlStr = sqlStr.replaceAll("0X", "");
            sqlStr = DatabaseUtilities.removeUnsopportedKeyword(sqlStr, " CONSTRAINT ", !(sqlStr = sqlStr.replaceAll(" NOT ", " ")).startsWith("CREATE"));
            sqlStr = DatabaseUtilities.removeUnsopportedKeyword(sqlStr, " DEFAULT ", false);
            sqlStr = DatabaseUtilities.removeUnsopportedKeyword(sqlStr, "ON FG_", false);
            matcher = Pattern.compile("(\\)\\s*ON\\s+)", 10).matcher(sqlStr);
            if (matcher.find() && (index = sqlStr.indexOf(onClause = matcher.group(1))) != -1) {
                sqlStr = sqlStr.substring(0, index + 1);
            }
        } else {
            sqlStr = "";
        }
        return sqlStr;
    }

    public static String removeUnsopportedKeyword(String sqlStr, String Keyword, boolean removeKeyword) {
        if (removeKeyword) {
            return sqlStr;
        }
        int defaultIndex = ((String)sqlStr).indexOf(Keyword);
        while (defaultIndex != -1) {
            int seperator = ((String)sqlStr).indexOf(",", defaultIndex);
            if (seperator == -1) {
                seperator = ((String)sqlStr).indexOf(")", defaultIndex);
            } else {
                while (true) {
                    String temp = ((String)sqlStr).substring(defaultIndex, seperator);
                    Pattern pattern = null;
                    Matcher matcher = null;
                    pattern = Pattern.compile("\\(");
                    matcher = pattern.matcher(temp);
                    int leftBracket = 0;
                    int rightBracket = 0;
                    while (matcher.find()) {
                        ++leftBracket;
                    }
                    pattern = Pattern.compile("\\)");
                    matcher = pattern.matcher(temp);
                    while (matcher.find()) {
                        ++rightBracket;
                    }
                    if (leftBracket == rightBracket) break;
                    int position = seperator + 1;
                    if ((seperator = ((String)sqlStr).indexOf(",", position)) != -1) continue;
                    seperator = ((String)sqlStr).indexOf(")", position);
                }
            }
            String preString = ((String)sqlStr).substring(0, defaultIndex);
            if (preString.trim().endsWith(",")) {
                preString = preString.substring(0, preString.lastIndexOf(","));
            }
            sqlStr = seperator != -1 ? preString + ((String)sqlStr).substring(seperator) : preString;
            defaultIndex = ((String)sqlStr).indexOf(Keyword);
        }
        return sqlStr;
    }
}

