/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.util.Utility;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class ContentFileCleaner {
    private boolean needToDeleteContentsForThisFeature = true;
    private List<String> contentFiles;
    private List<String> requiredFeatures;
    private List<String> unwantedContents;

    public ContentFileCleaner(String[] contentFiles, String[] requiredFeatures) {
        this.contentFiles = Arrays.asList(contentFiles);
        this.requiredFeatures = Arrays.asList(requiredFeatures);
    }

    public ContentFileCleaner(String[] contentFiles, String[] requiredFeatures, String[] unwantedContents) {
        this.contentFiles = Arrays.asList(contentFiles);
        this.requiredFeatures = Arrays.asList(requiredFeatures);
        this.unwantedContents = Arrays.asList(unwantedContents);
    }

    public boolean cleanup(EnabledClientFeatures enabledFeatures) {
        this.needToDeleteContentsForThisFeature = this.checkFeatures(enabledFeatures);
        this.cleanupContentFiles();
        return this.needToDeleteContentsForThisFeature;
    }

    public boolean checkFeatures(EnabledClientFeatures enabledFeatures) {
        System.out.println("ContentFileCleaner> checkFeatures>> Check content file for enabled client features......");
        Vector<ClientFeature> clientFeatures = null;
        boolean needDelete = true;
        if (null != enabledFeatures) {
            clientFeatures = enabledFeatures.getClientFeature();
        }
        if (null != clientFeatures) {
            block0: for (ClientFeature clientFeature : clientFeatures) {
                if (needDelete) {
                    if (!clientFeature.getOptEnabled().booleanValue()) continue;
                    for (String featureName : this.requiredFeatures) {
                        if (!featureName.equalsIgnoreCase(clientFeature.getFeatureName())) continue;
                        System.out.println("ContentFileCleaner> checkFeatures>> Content file(s) is required for " + featureName);
                        needDelete = false;
                        continue block0;
                    }
                    continue;
                }
                break;
            }
        } else {
            System.out.println("ContentFileCleaner> checkFeatures>> No client feature enabled, will delete all content file(s).");
        }
        return needDelete;
    }

    private void cleanupContentFiles() {
        System.out.println("ContentFileCleaner> cleanupContentFiles>> Start to clean up content file ......");
        if (this.unwantedContents != null) {
            for (String file : this.unwantedContents) {
                if (!Utility.deleteFile(file)) continue;
                System.out.println("ContentFileCleaner> cleanupContentFiles>> Deleted unwanted content file: " + file);
            }
        }
        if (!this.needToDeleteContentsForThisFeature) {
            System.out.println("ContentFileCleaner> cleanupContentFiles>> No need to delete any content file.");
            return;
        }
        for (String file : this.contentFiles) {
            if (!Utility.deleteFile(file)) continue;
            System.out.println("ContentFileCleaner> cleanupContentFiles>> Deleted content file: " + file);
        }
    }

    public static class ContentFileCleanerWorker {
        private ContentFileCleaner[] cleaners;
        private EnabledClientFeatures enabledFeatures;

        public ContentFileCleanerWorker(ContentFileCleaner[] cleaners, EnabledClientFeatures enabledFeatures) {
            this.cleaners = cleaners == null ? null : (ContentFileCleaner[])cleaners.clone();
            this.enabledFeatures = enabledFeatures;
        }

        public void startWork() {
            if (null == this.cleaners) {
                return;
            }
            for (ContentFileCleaner cleaner : this.cleaners) {
                cleaner.cleanup(this.enabledFeatures);
            }
        }
    }
}

