/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    private static Integer INTEGER_ONE = 1;

    private CollectionUtils() {
    }

    public static <E> boolean hasIntersection(Collection<E> c1, Collection<E> c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        for (E object : c1) {
            if (!c2.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static void reverseArray(Object[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static List<String> toList(String[] array) {
        if (array == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(array);
    }

    public static Collection<?> intersection(Collection<?> a, Collection<?> b) {
        ArrayList list = new ArrayList();
        Map<Object, Integer> mapa = CollectionUtils.getCardinalityMap(a);
        Map<Object, Integer> mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    private static Map<Object, Integer> getCardinalityMap(Collection<?> coll) {
        HashMap<Object, Integer> count = new HashMap<Object, Integer>();
        for (Object obj : coll) {
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, INTEGER_ONE);
                continue;
            }
            count.put(obj, c + 1);
        }
        return count;
    }

    private static final int getFreq(Object obj, Map<Object, Integer> freqMap) {
        Integer count = freqMap.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }
}

