/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.opencsv.CSVParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSVReader {
    private static final Logger logger = Logger.getLogger(CSVReader.class.getName());
    private static final String SEM_ADMIN = "SemAdministrator";
    private BufferedReader input = null;
    private String[] columnNames = null;
    private String[] columnValues = null;
    private String buf = null;
    private boolean suppressHeaders = false;
    private String tableName = null;
    private String headerLine = null;
    private boolean isInputStreamClosed = false;
    private HashMap<String, Integer> columnNameIndex = null;
    private boolean closeInputStream = true;
    private CSVParser csvParser = null;
    private int numberOfColumns = -1;

    public CSVReader(String fileName, String tableName, char separator, boolean suppressHeaders, String charset) throws IOException, SQLException {
        this(new FileInputStream(fileName), tableName, separator, suppressHeaders, charset, true);
    }

    public CSVReader(InputStream streamInput, String tableName, char separator, boolean suppressHeaders, String charset, boolean streamClose) throws IOException, SQLException {
        this.csvParser = new CSVParser(separator, '\"', '\u0000');
        this.tableName = tableName;
        this.suppressHeaders = suppressHeaders;
        this.closeInputStream = streamClose;
        this.columnNameIndex = new HashMap();
        this.input = charset != null ? new BufferedReader(new InputStreamReader(streamInput, charset), 524288) : new BufferedReader(new InputStreamReader(streamInput, Charset.defaultCharset()), 524288);
        this.populateColumnNames();
        this.populateColumnIndex();
    }

    public String readNextLine() throws SQLException {
        if (this.isInputStreamClosed) {
            return null;
        }
        String dataLine = null;
        try {
            if (this.suppressHeaders && this.buf != null) {
                dataLine = this.buf;
                this.buf = null;
            } else {
                dataLine = this.input.readLine();
            }
            if (dataLine == null) {
                this.close();
            }
        }
        catch (IOException ex) {
            throw new SQLException(ex.toString());
        }
        return dataLine;
    }

    public String readAndParseNextLine() throws Exception {
        String dataLine = this.readNextLine();
        if (dataLine != null) {
            dataLine = this.parseCsvLineAndPopulateColumnValues(dataLine);
        }
        return dataLine;
    }

    public boolean next() throws SQLException {
        String dataLine = this.readNextLine();
        if (dataLine == null) {
            return false;
        }
        this.parseCsvLineAndPopulateColumnValues(dataLine);
        return true;
    }

    public void close() {
        try {
            if (this.closeInputStream) {
                this.input.close();
            }
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "CSVReader >> Exception while closing input stream", ex);
        }
        this.isInputStreamClosed = true;
        this.buf = null;
        if (this.columnNameIndex != null) {
            this.columnNameIndex.clear();
        }
        this.columnNameIndex = null;
    }

    private void populateColumnNames() throws SQLException {
        try {
            this.headerLine = this.input.readLine();
            if (this.suppressHeaders) {
                this.buf = this.headerLine;
                String[] data = this.parseCsvLineHeader(this.buf);
                this.columnNames = new String[data.length];
                for (int i = 0; i < data.length; ++i) {
                    this.columnNames[i] = "COLUMN" + String.valueOf(i + 1);
                }
            } else {
                this.columnNames = this.parseCsvLineHeader(this.headerLine);
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private void populateColumnIndex() {
        this.numberOfColumns = this.columnNames.length;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnNameIndex.put(this.columnNames[i].toLowerCase(), i);
            if (this.tableName == null) continue;
            this.columnNameIndex.put((this.tableName + "." + this.columnNames[i]).toLowerCase(), i);
        }
        this.columnValues = new String[this.numberOfColumns];
    }

    private String[] parseCsvLineHeader(String header) throws SQLException {
        try {
            if (header == null) {
                return null;
            }
            ArrayList<String> tokensOnThisLine = new ArrayList<String>(10);
            String[] strArr = this.csvParser.parseLineMulti(header);
            tokensOnThisLine.addAll(Arrays.asList(strArr));
            while (this.csvParser.isPending()) {
                strArr = this.csvParser.parseLineMulti(this.readNextLine());
                tokensOnThisLine.addAll(Arrays.asList(strArr));
            }
            return tokensOnThisLine.toArray(new String[0]);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private String[] parseCsvLine(String inputLine) throws SQLException {
        try {
            if (inputLine == null) {
                return null;
            }
            String[] parsedData = new String[this.numberOfColumns];
            int i = 0;
            int j = 0;
            String[] strArr = this.csvParser.parseLineMulti(inputLine);
            for (j = 0; j < strArr.length; ++j) {
                parsedData[i++] = strArr[j];
            }
            while (this.csvParser.isPending()) {
                strArr = this.csvParser.parseLineMulti(this.readNextLine());
                for (j = 0; j < strArr.length; ++j) {
                    parsedData[i++] = strArr[j];
                }
            }
            if (i != this.numberOfColumns) {
                logger.log(Level.FINEST, "CSVReader >> parseCsvLineAndPopulateColumnValues, expected number of columns={},  actual number of columns={}, line=\n{}", new Object[]{this.numberOfColumns, i, inputLine});
            }
            return parsedData;
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private String parseCsvLineAndPopulateColumnValues(String inputLine) throws SQLException {
        try {
            if (inputLine == null) {
                return null;
            }
            int i = 0;
            int j = 0;
            StringBuilder sb = new StringBuilder(inputLine);
            String[] strArr = this.csvParser.parseLineMulti(inputLine);
            while (j < strArr.length) {
                this.columnValues[i++] = strArr[j++];
            }
            while (this.csvParser.isPending()) {
                String nextLine = this.readNextLine();
                strArr = this.csvParser.parseLineMulti(nextLine);
                sb.append("\n");
                sb.append(nextLine);
                for (j = 0; j < strArr.length; ++j) {
                    this.columnValues[i++] = strArr[j];
                }
            }
            if (i != this.numberOfColumns) {
                String logLine = inputLine;
                if (logLine.contains(SEM_ADMIN)) {
                    logLine = "[...]";
                }
                logger.log(Level.FINEST, "CSVReader >> parseCsvLineAndPopulateColumnValues, expected number of columns={},  actual number of columns={}, line=\n{}", new Object[]{this.numberOfColumns, i, logLine});
            }
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private int getColumnIndexByName(String columnName) throws SQLException {
        Integer ii = this.columnNameIndex.get(columnName.toLowerCase());
        if (ii == null) {
            throw new SQLException("Column '" + columnName + "' not found.");
        }
        return ii;
    }

    public boolean isColumnValid(String columnName) {
        Integer ii = this.columnNameIndex.get(columnName.toLowerCase());
        return ii != null;
    }

    public String getHeaderLine() {
        return this.headerLine;
    }

    public String[] getColumnNames() {
        return this.columnNames == null ? null : (String[])this.columnNames.clone();
    }

    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        return "";
    }

    public Hashtable<String, String> getColumnNamesAndValues() {
        Hashtable<String, String> ht = new Hashtable<String, String>(this.numberOfColumns);
        if (this.columnValues != null) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                ht.put(this.columnNames[i], this.columnValues[i]);
            }
        }
        return ht;
    }

    public String getValueByColumnIndex(int columnIndex) {
        if (columnIndex >= this.columnValues.length) {
            return null;
        }
        return this.columnValues[columnIndex];
    }

    public String getColumnValue(String columnName) throws SQLException {
        int columnIndex = this.getColumnIndexByName(columnName);
        return this.getValueByColumnIndex(columnIndex);
    }

    public String[] getColumnValues() {
        return this.columnValues == null ? null : (String[])this.columnValues.clone();
    }

    public String getValueByColumnName(String inputLine, String columnName) throws SQLException {
        int columnIndex = this.getColumnIndexByName(columnName);
        String[] strArr = this.parseCsvLine(inputLine);
        try {
            return strArr[columnIndex];
        }
        catch (Exception ex) {
            throw new SQLException("Value of Column '" + columnName + "' not found.");
        }
    }
}

