/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

public final class BooleanWrapper {
    private Boolean value = null;
    public static final BooleanWrapper TRUE_VALUE = new BooleanWrapper(true);
    public static final BooleanWrapper FALSE_VALUE = new BooleanWrapper(false);
    public static final BooleanWrapper NULL_VALUE = new BooleanWrapper(null);

    private BooleanWrapper(Boolean value) {
        this.value = value;
    }

    public static BooleanWrapper getInstance(Boolean value) {
        if (value == null) {
            return NULL_VALUE;
        }
        if (value.booleanValue()) {
            return TRUE_VALUE;
        }
        return FALSE_VALUE;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean booleanValue() {
        if (this.value == null) {
            throw new NullPointerException();
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BooleanWrapper)) {
            return false;
        }
        BooleanWrapper anotherObj = (BooleanWrapper)o;
        return this.value.equals(anotherObj.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        if (this.value.booleanValue()) {
            return 1;
        }
        return -1;
    }
}

