/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class Base64Util {
    private static final int CHUNK_SIZE = 76;
    private static final int MAX_NO_OF_CHAR_IN_CHUNKED_LINE_WITHOUT_NEW_LINE = 75;
    private static final String CHUNK_SEPARATOR = "\r\n";
    private static final Pattern p = Pattern.compile("(?:(?:.*\r\n(?:\\S{1,75}))|(?:\\S{1,75}))\r\n$");

    public static String encodeString(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        String encode = new Base64(76).encodeAsString(binaryData);
        Matcher m = p.matcher(encode);
        if (m.matches()) {
            return encode.trim();
        }
        return encode;
    }

    public static byte[] encode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        return Base64Util.encodeString(binaryData).getBytes(Charset.defaultCharset());
    }

    public static void encodeString(byte[] binaryData, OutputStream outStream) throws IOException {
        binaryData = Base64Util.encode(binaryData);
        outStream.write(binaryData, 0, binaryData.length);
        outStream.flush();
    }

    public static byte[] decode(String base64String) {
        return Base64.decodeBase64((String)base64String);
    }
}

