/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.util.DateTimeManager;
import com.sygate.scm.util.StringUtilities;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupUtils {
    static final long MIGRATION_BACKUP_KEEP_TIME = 2592000000L;
    static final String BACKUP_FOLDER = "backup";
    static final String ZIP_SUFFIX = ".zip";
    static final String MIGRATION_ZIP_SUFFIX = ".migration.zip";
    private static Logger logger = Logger.getLogger(BackupUtils.class.getName());

    private BackupUtils() {
    }

    public static long getMigrationFilePurgeTime() {
        return System.currentTimeMillis() - 2592000000L;
    }

    public static DateFormat getFormatOfDBBackupFilename() {
        return DateTimeManager.getFormatOfDBBackupFilename();
    }

    public static DateFormat getFormatOfDBBackupFilenameBeforeAmber() {
        return DateTimeManager.getFormatOfDBBackupFilenameBeforeAmber();
    }

    public static String suffix() {
        return ZIP_SUFFIX;
    }

    public static String migrationSuffix() {
        return MIGRATION_ZIP_SUFFIX;
    }

    public static String getBackupFilename() {
        return BackupUtils.getBackupFilename(TimeUtil.getServerTime());
    }

    public static String getBackupFilename(Date date) {
        return BackupUtils.getBackupFilename(date.getTime());
    }

    public static String getBackupFilename(long time) {
        return BackupUtils.getFormatOfDBBackupFilename().format(time) + BackupUtils.suffix();
    }

    public static String getBackupFileFullPath(String dataRootFolder, String fileName) {
        return StringUtilities.join(BackupUtils.getBackupFolder(dataRootFolder), StringUtilities.SYSTEM_FILE_SEPARATOR, fileName);
    }

    public static String getBackupFolder(String dataRootFolder) {
        return StringUtilities.join(dataRootFolder, StringUtilities.SYSTEM_FILE_SEPARATOR, BACKUP_FOLDER);
    }

    public static String getBackupCurrentFolder(String dataRootFolder) {
        return StringUtilities.join(dataRootFolder, StringUtilities.SYSTEM_FILE_SEPARATOR, BACKUP_FOLDER, StringUtilities.SYSTEM_FILE_SEPARATOR, BackupUtils.getFormatOfDBBackupFilename().format(TimeUtil.getServerTime()));
    }

    public static Map<Long, String> getAllBackupDate(String dataRootFolder) {
        return BackupUtils.getAllBackupDate(dataRootFolder, false);
    }

    public static Map<Long, String> getAllBackupDate(String dataRootFolder, boolean isForMigration) {
        if (StringUtilities.isEmpty(dataRootFolder)) {
            throw new IllegalArgumentException("The data root folder cannot be null!");
        }
        if (!new File(dataRootFolder).exists()) {
            throw new IllegalStateException("The data root folder does not exist: " + dataRootFolder);
        }
        HashMap<Long, String> result = new HashMap<Long, String>();
        File backupFolder = new File(BackupUtils.getBackupFolder(dataRootFolder));
        String[] files = backupFolder.list();
        if (null != files) {
            for (String fileName : files) {
                try {
                    if (isForMigration && fileName.toLowerCase().endsWith(BackupUtils.migrationSuffix())) {
                        result.put(BackupUtils.getFormatOfDBBackupFilename().parse(fileName.substring(0, fileName.length() - BackupUtils.migrationSuffix().length())).getTime(), fileName);
                        continue;
                    }
                    if (isForMigration || fileName.toLowerCase().endsWith(BackupUtils.migrationSuffix()) || !fileName.toLowerCase().endsWith(BackupUtils.suffix())) continue;
                    result.put(BackupUtils.getFormatOfDBBackupFilename().parse(fileName.substring(0, fileName.length() - BackupUtils.suffix().length())).getTime(), fileName);
                }
                catch (ParseException pe) {
                    logger.log(Level.WARNING, pe.getMessage());
                }
            }
        }
        return result;
    }

    public static DateFormat getFormatOfDBBackupTime() {
        return DateTimeManager.getFormatOfDBBackupTime();
    }
}

