/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ROSType;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class AutoUpgradeUtils {
    private static final String PROPERTY_FILE_NAME = "ClientPackageInfo.properties";
    private static final String LEGACY_PKG_OS_WIN32 = "OS.Win32.Legacy.SupportOSStr";
    private static final String LEGACY_PKG_OS_WIN64 = "OS.Win64.Legacy.SupportOSStr";
    private static final String DEFAULT_PKG_OS_WIN32 = "OS.Win32.default.SupportOSStr";
    private static final String DEFAULT_PKG_OS_WIN64 = "OS.Win64.default.SupportOSStr";
    private static final String DEFAULT_PKG_OS_ODC_WIN = "OS.ODC.Windows.default.SupportOSStr";
    private static final String DEFAULT_PKG_OS_ODC_MAC = "OS.ODC.Mac.default.SupportOSStr";
    private static final String DEFAULT_PKG_OS_MAC = "OS.Mac.default.SupportOSStr";
    public static final String MIN_VERSION = "MinVersion";
    public static final String MAX_VERSION = "MaxVersion";
    public static final String TYPE_WINDOWS_32BIT = "0101";
    public static final String TYPE_WINDOWS_64BIT = "0102";
    public static final String TYPE_WINDOWS_EMBEDDED = "0103";
    private static final Properties CLIENT_PACKAGE_INFO_PROP = new Properties();
    private static ClientPackageInfo win32LegacyClientPkgInfo;
    private static ClientPackageInfo win64LegacyClientPkgInfo;
    private static ClientPackageInfo win32DefaultClientPkgInfo;
    private static ClientPackageInfo win64DefaultClientPkgInfo;
    private static ClientPackageInfo odcWinDefaultClientPkgInfo;
    private static ClientPackageInfo odcMacDefaultClientPkgInfo;
    private static ClientPackageInfo macDefaultClientPkgInfo;
    private static final int WIN_OS_TYPE = 256;
    private static final String MAC_OS_TYPE = "0200";
    private static final int TYPE_32_BIT_OS = 1;
    private static final int TYPE_64_BIT_OS = 2;
    private static final int TYPE_EMBEDDED_OS = 3;
    public static final String LINUX_OS_TYPE = "0300";
    public static final String TYPE_UNKNOWN = "0000";

    private AutoUpgradeUtils() {
    }

    public static Properties getClientPackageInfoProp() {
        return CLIENT_PACKAGE_INFO_PROP;
    }

    public static List<Map<String, String>> getWin32LegacyInfo() {
        return win32LegacyClientPkgInfo.getInfoList();
    }

    public static List<Map<String, String>> getWin64LegacyInfo() {
        return win64LegacyClientPkgInfo.getInfoList();
    }

    public static List<Map<String, String>> getWin32DefaultInfo() {
        return win32DefaultClientPkgInfo.getInfoList();
    }

    public static List<Map<String, String>> getWin64DefaultInfo() {
        return win64DefaultClientPkgInfo.getInfoList();
    }

    public static List<Map<String, String>> getODCWinDefaultInfo() {
        return odcWinDefaultClientPkgInfo.getInfoList();
    }

    public static List<Map<String, String>> getODCMacDefaultInfo() {
        return odcMacDefaultClientPkgInfo.getInfoList();
    }

    public static List<Map<String, String>> getMacDefaultInfo() {
        return macDefaultClientPkgInfo.getInfoList();
    }

    public static boolean isMacSoftwarePackage(SoftwarePackage sp) {
        PackageInfo info = sp.getPackageInfo();
        String platformType = info.getOptPlatformType();
        if (StringUtilities.isEmpty(platformType)) {
            Integer type = info.getType();
            return type == 160;
        }
        return "Mac".equalsIgnoreCase(platformType);
    }

    public static boolean isSSEPSoftwarePackage(SoftwarePackage sp) {
        String pkgVersion = sp.getPackageInfo().getVersion();
        return !StringUtilities.isEmpty(pkgVersion) && pkgVersion.matches("^5\\..*");
    }

    public static boolean isLegacyWindowsPackageForAutoUpgrade(SoftwarePackage sp) {
        String pkgVersion;
        if (AutoUpgradeUtils.isMacSoftwarePackage(sp)) {
            return false;
        }
        if (AutoUpgradeUtils.isSSEPSoftwarePackage(sp)) {
            return true;
        }
        Integer type = sp.getPackageInfo().getType();
        if (type == 300 || type == 301) {
            return false;
        }
        PackageInfo packageInfo = sp.getPackageInfo();
        String string = pkgVersion = Boolean.TRUE.equals(packageInfo.getOptSecurityFixPackage()) ? packageInfo.getOptProductBuildNum() : packageInfo.getVersion();
        return AutoUpgradeUtils.isLegacyAgent(pkgVersion);
    }

    public static String getPackageClientTypeValue(SoftwarePackage sp) {
        PackageInfo pkgInfo;
        Object clientType = "";
        if (sp != null && (pkgInfo = sp.getPackageInfo()) != null) {
            clientType = String.valueOf(pkgInfo.getType());
            if (AutoUpgradeUtils.isLegacyWindowsPackageForAutoUpgrade(sp)) {
                clientType = (String)clientType + "A";
            }
        }
        return clientType;
    }

    public static String getOSTypeString(ROSType rOsType, String osFullName) {
        if (rOsType.isValid()) {
            if (rOsType.isWindowsOS()) {
                if (!StringUtilities.isEmpty(osFullName)) {
                    try (Formatter fmt = new Formatter();){
                        int value = 0;
                        value = osFullName.indexOf("x64") > 0 ? 258 : (osFullName.indexOf("Embedded") > 0 ? 259 : 257);
                        String string = fmt.format("0%x", value).toString();
                        return string;
                    }
                }
            } else {
                if (rOsType.isMacOS()) {
                    return MAC_OS_TYPE;
                }
                if (rOsType.isLinuxOS()) {
                    return LINUX_OS_TYPE;
                }
            }
        }
        return TYPE_UNKNOWN;
    }

    public static String getOSVersionString(ROSType rOsType, String servicePack) {
        int servicePackInt = 0;
        if (!StringUtilities.isEmpty(servicePack)) {
            String[] splitStrings = servicePack.split("\\D+");
            for (int i = 0; i < splitStrings.length && servicePackInt == 0; ++i) {
                if (splitStrings[i].length() <= 0) continue;
                servicePackInt = Integer.parseInt(splitStrings[i]);
            }
        }
        int version = (rOsType.getMajorVersion() << 24) + (rOsType.getMinorVersion() << 16) + (servicePackInt << 8) + 0;
        return AutoUpgradeUtils.getFixedLengthHexString(version, 8);
    }

    public static String getVersionFromMajorMinorInfo(int major, int minor) {
        if (major < 0) {
            major = 0;
        }
        if (minor < 0) {
            minor = 0;
        }
        int version = (major << 24) + (minor << 16);
        return AutoUpgradeUtils.getFixedLengthHexString(version, 8);
    }

    public static String getFixedLengthHexString(int DataValue, int requiredSize) {
        Object hexStr = Integer.toHexString(DataValue);
        int paddingNeeded = requiredSize - ((String)hexStr).length();
        while (paddingNeeded-- > 0) {
            hexStr = "0" + (String)hexStr;
        }
        return hexStr;
    }

    public static boolean isLegacyAgent(String agentVersion) {
        return !StringUtilities.isEmpty(agentVersion) && Utility.compareVersion(agentVersion, "14.0.0.0") < 0;
    }

    public static boolean isAgentVersionBeforeAmber(String agentVersion) {
        return !StringUtilities.isEmpty(agentVersion) && Utility.compareVersion(agentVersion, "12.1.0.0") < 0;
    }

    public static boolean isAgentOSVersionSupported(Long rOSType, String operatingSystem, String servicePack) {
        if (rOSType != null) {
            String OSVersion2 = AutoUpgradeUtils.getOSVersionString(new ROSType(String.valueOf(rOSType)), servicePack);
            String OSType2 = AutoUpgradeUtils.getOSTypeString(new ROSType(String.valueOf(rOSType)), operatingSystem);
            if (!StringUtilities.isEmpty(OSType2)) {
                if (TYPE_WINDOWS_32BIT.equals(OSType2)) {
                    return AutoUpgradeUtils.isOSVersionMeetTheRequirement(AutoUpgradeUtils.getWin32DefaultInfo(), OSVersion2);
                }
                if (TYPE_WINDOWS_64BIT.equals(OSType2)) {
                    return AutoUpgradeUtils.isOSVersionMeetTheRequirement(AutoUpgradeUtils.getWin64DefaultInfo(), OSVersion2);
                }
            }
        }
        return true;
    }

    protected static boolean isOSVersionMeetTheRequirement(List<Map<String, String>> infoList, String OSLevel) {
        for (Map<String, String> infoMap : infoList) {
            long agentOSValue;
            long minVersion = Long.decode(infoMap.get(MIN_VERSION));
            long maxVersion = Long.decode(infoMap.get(MAX_VERSION));
            if (StringUtilities.isEmpty(OSLevel) || (agentOSValue = Long.parseLong(OSLevel, 16)) < minVersion || agentOSValue > maxVersion) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialOSProperties() {
        InputStream is = null;
        try {
            is = AutoUpgradeUtils.class.getResourceAsStream(PROPERTY_FILE_NAME);
            CLIENT_PACKAGE_INFO_PROP.load(is);
            String win32Legacy = CLIENT_PACKAGE_INFO_PROP.getProperty(LEGACY_PKG_OS_WIN32);
            win32LegacyClientPkgInfo = new ClientPackageInfo(win32Legacy);
            String win64Legacy = CLIENT_PACKAGE_INFO_PROP.getProperty(LEGACY_PKG_OS_WIN64);
            win64LegacyClientPkgInfo = new ClientPackageInfo(win64Legacy);
            String win32Default = CLIENT_PACKAGE_INFO_PROP.getProperty(DEFAULT_PKG_OS_WIN32);
            win32DefaultClientPkgInfo = new ClientPackageInfo(win32Default);
            String win64Default = CLIENT_PACKAGE_INFO_PROP.getProperty(DEFAULT_PKG_OS_WIN64);
            win64DefaultClientPkgInfo = new ClientPackageInfo(win64Default);
            String odcWinDefault = CLIENT_PACKAGE_INFO_PROP.getProperty(DEFAULT_PKG_OS_ODC_WIN);
            odcWinDefaultClientPkgInfo = new ClientPackageInfo(odcWinDefault);
            String odcMacDefault = CLIENT_PACKAGE_INFO_PROP.getProperty(DEFAULT_PKG_OS_ODC_MAC);
            odcMacDefaultClientPkgInfo = new ClientPackageInfo(odcMacDefault);
            String macDefault = CLIENT_PACKAGE_INFO_PROP.getProperty(DEFAULT_PKG_OS_MAC);
            macDefaultClientPkgInfo = new ClientPackageInfo(macDefault);
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
        }
        finally {
            IOUtilities.closeInputStream(is);
        }
    }

    static {
        AutoUpgradeUtils.initialOSProperties();
    }

    public static class ClientPackageInfo {
        private List<Map<String, String>> infoList = new ArrayList<Map<String, String>>();

        public ClientPackageInfo(String infoString) {
            this.parseInfoString(infoString);
        }

        private void parseInfoString(String infoString) {
            if (!StringUtilities.isEmpty(infoString)) {
                String[] info;
                for (String pairs : info = infoString.split(";")) {
                    String[] pair = pairs.split(",");
                    HashMap<String, String> versionMap = new HashMap<String, String>();
                    for (String osInfo : pair) {
                        int index = osInfo.indexOf(":");
                        if (index <= 0) continue;
                        String versionStr = osInfo.substring(0, index);
                        String versionValue = osInfo.substring(index + 1, osInfo.length());
                        versionMap.put(versionStr, versionValue);
                    }
                    this.infoList.add(versionMap);
                }
            }
        }

        public List<Map<String, String>> getInfoList() {
            return Collections.unmodifiableList(this.infoList);
        }
    }
}

