/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AdaptiveConfiguration;
import com.sygate.scm.common.configobject.schema.AdaptivePolicy;
import com.sygate.scm.common.configobject.schema.BPEEnhancementsRule;
import com.sygate.scm.common.configobject.schema.BPEEnhancementsRulesList;
import com.sygate.scm.util.DeterministicIdWasher;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.SystemLevel;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class AdaptivePolicyUtility {
    public static final String RULES_OBJECT_NAME = "SymantecAdaptiveRules";
    public static final String RULES_OBJECT_TARGET_TYPE = "SymantecAdaptiveRules";
    private static AdaptivePolicyUtility singleton = new AdaptivePolicyUtility();
    private static final Logger logger = Logger.getLogger(AdaptivePolicyUtility.class.getName());
    private AdaptivePolicy cachedAdaptivePolicy = null;

    private AdaptivePolicyUtility() {
    }

    public static AdaptivePolicyUtility getInstance() {
        return singleton;
    }

    public AdaptivePolicy getDefaultAdaptivePolicy(String seed) {
        if (this.cachedAdaptivePolicy == null) {
            try (InputStream in = Template.class.getResourceAsStream("default_shared_policies_template.xml");){
                Template temp = TemplateManager.getTemplate(in);
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(temp.getXML());
                for (AbstractSchema schema : container.getChildren()) {
                    AdaptivePolicy policy;
                    AbstractSchema conObj;
                    SchemaContainer con = (SchemaContainer)schema;
                    Vector<AbstractSchema> children = con.getChildren();
                    if (children.isEmpty() || !((conObj = children.get(0)) instanceof AdaptivePolicy)) continue;
                    this.cachedAdaptivePolicy = policy = (AdaptivePolicy)conObj;
                    break;
                }
            }
            catch (RuntimeException exc) {
                throw exc;
            }
            catch (Exception exc) {
                logger.log(SystemLevel.STDERR, "", exc);
            }
        }
        if (this.cachedAdaptivePolicy == null) {
            return null;
        }
        AdaptivePolicy cloneAdaptivePolicy = (AdaptivePolicy)this.cachedAdaptivePolicy.clone();
        DeterministicIdWasher idWasher = new DeterministicIdWasher();
        if (StringUtils.isBlank((CharSequence)seed)) {
            seed = GUIDGenerator.getInstance().getGUIDString();
        }
        idWasher.resetTopLevelObjectIDs((TopLevelObject)cloneAdaptivePolicy, seed);
        return cloneAdaptivePolicy;
    }

    public boolean mergeSymantecRules(AdaptivePolicy newAdaptivePolicy, BPEEnhancementsRulesList newRuleList) {
        BPEEnhancementsRulesList ruleList;
        if (newAdaptivePolicy == null || newRuleList == null) {
            return false;
        }
        boolean bChanged = false;
        AdaptiveConfiguration config = newAdaptivePolicy.getOptAdaptiveConfiguration();
        if (config == null) {
            config = new AdaptiveConfiguration();
            newAdaptivePolicy.setOptAdaptiveConfiguration(config);
        }
        if ((ruleList = config.getOptBPEEnhancementsRulesList()) == null) {
            ruleList = new BPEEnhancementsRulesList();
            config.setOptBPEEnhancementsRulesList(ruleList);
        }
        HashSet<String> ruleSet = new HashSet<String>();
        for (BPEEnhancementsRule rule : ruleList.getBPEEnhancementsRule()) {
            ruleSet.add(rule.getOptName());
        }
        for (BPEEnhancementsRule newRule : newRuleList.getBPEEnhancementsRule()) {
            if (ruleSet.contains(newRule.getOptName())) continue;
            ruleList.addBPEEnhancementsRule(newRule);
            bChanged = true;
        }
        return bChanged;
    }

    public static enum Prevalence {
        UNKNOWN,
        ZERO,
        LOW,
        MED,
        HIGH,
        LEARNING;

    }
}

