/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.AvGeneral;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.AvQuarantine;
import com.sygate.scm.common.configobject.schema.ForwardedEvent;
import com.sygate.scm.common.configobject.schema.LogHandling;
import com.sygate.scm.common.configobject.schema.SecurityRiskGroup;
import com.sygate.scm.hi.library.HiObjectManager;
import com.sygate.scm.util.DynaCatManipulationUtility;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class AVUtility {
    private static AVUtility singlton = new AVUtility();
    private Set<Long> validEventIdSet = new HashSet<Long>();
    private AdminDefinedScan cachedAdminDefinedScan = null;
    private HashMap<String, Integer> mapGroupNameIndex = new HashMap();

    private AVUtility() {
        long[] validEventIds = new long[]{2L, 3L, 4L, 5L, 6L, 7L, 12L, 13L, 14L, 16L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 26L, 27L, 33L, 39L, 40L, 45L, 46L, 47L, 48L, 49L, 50L, 51L, 54L, 55L, 57L, 58L, 65L, 66L, 71L, 76L, 77L};
        for (int i = 0; i < validEventIds.length; ++i) {
            this.validEventIdSet.add(validEventIds[i]);
        }
        this.mapGroupNameIndex.put("MacroVirusAction", 0);
        this.mapGroupNameIndex.put("NonMacroVirusAction", 1);
        this.mapGroupNameIndex.put("SecurityRisksAction", 2);
    }

    public static AVUtility getInstance() {
        return singlton;
    }

    public ArrayList<ForwardedEvent> filterUnsupportedEvents(AvPolicy policy) {
        ArrayList<ForwardedEvent> removedEvents = new ArrayList<ForwardedEvent>();
        AvGeneral general = policy.getOptAvGeneral();
        if (general != null) {
            LogHandling logHandling = general.getLogHandling();
            for (ForwardedEvent event : logHandling.getForwardedEvent()) {
                if (this.isSupported(event)) continue;
                logHandling.removeForwardedEvent(event);
                removedEvents.add(event);
            }
        }
        return removedEvents;
    }

    public boolean checkQuarantinePath(AvPolicy policy) {
        boolean result = false;
        AvQuarantine q = policy.getOptAvQuarantine();
        if (q != null) {
            boolean useDefault = false;
            if (q.getOptUseDefaultDirectory() != null) {
                useDefault = q.getOptUseDefaultDirectory();
            } else if (q.getDefUseDefaultDirectory() != null) {
                useDefault = q.getDefUseDefaultDirectory();
            }
            if (!(useDefault || q.getOptQuarantineDirectory() != null && q.getOptQuarantineDirectory().length() > 0)) {
                q.setOptUseDefaultDirectory(true);
                result = true;
            }
        }
        return result;
    }

    public boolean isSupported(ForwardedEvent event) {
        return this.validEventIdSet.contains(event.getEventID());
    }

    public boolean checkSecurityRisksAction(ApActions apActions, String securityRiskGroupName, boolean remedy) {
        boolean hasSecurityRisksAction = false;
        if (apActions == null) {
            return false;
        }
        String securityRiskGroupCode = DynaCatManipulationUtility.checkSecurityGroupLegacy(securityRiskGroupName);
        if (securityRiskGroupCode == null) {
            securityRiskGroupCode = securityRiskGroupName;
        }
        for (int i = 0; i < apActions.getSecurityRiskGroupCount(); ++i) {
            String groupName = apActions.getSecurityRiskGroup(i).getName();
            if (!securityRiskGroupName.equalsIgnoreCase(groupName) && !securityRiskGroupCode.equalsIgnoreCase(groupName)) continue;
            hasSecurityRisksAction = true;
            break;
        }
        if (!hasSecurityRisksAction && remedy) {
            Integer index = this.mapGroupNameIndex.get(securityRiskGroupName);
            SecurityRiskGroup defaultGroup = this.getDefaultSecurityRiskGroup(securityRiskGroupName);
            if (index != null && defaultGroup != null) {
                apActions.setReadonly(false, false);
                apActions.addSecurityRiskGroup(index, defaultGroup);
            }
        }
        return hasSecurityRisksAction;
    }

    private SecurityRiskGroup getDefaultSecurityRiskGroup(String securityRiskGroupName) {
        SecurityRiskGroup defaultSecurityRisksAction = null;
        ApActions apActions = this.getDefaultApActions();
        if (apActions == null) {
            return null;
        }
        for (int i = 0; i < apActions.getSecurityRiskGroupCount(); ++i) {
            SecurityRiskGroup group = apActions.getSecurityRiskGroup(i);
            if (!group.getName().equalsIgnoreCase(securityRiskGroupName)) continue;
            defaultSecurityRisksAction = group;
            break;
        }
        return defaultSecurityRisksAction;
    }

    public ApActions getDefaultMacApActions() {
        ApActions apActions = new ApActions();
        SecurityRiskGroup securityRiskGroup = new SecurityRiskGroup();
        apActions.addSecurityRiskGroup(securityRiskGroup);
        securityRiskGroup.setName("MacroVirusAction");
        ApAction apAction = new ApAction();
        apAction.setFirstAction(ApAction.CLEAN);
        apAction.setSecondAction(ApAction.QUARANTINE);
        apAction.setOptLockFirstAction(Boolean.TRUE);
        apAction.setOptLockSecondAction(Boolean.TRUE);
        securityRiskGroup.setApAction(apAction);
        return apActions;
    }

    public ApActions getDefaultApActions() {
        block4: {
            try {
                if (this.cachedAdminDefinedScan != null) break block4;
                AbstractSchema.registerObjectManager("hi", new HiObjectManager());
                InputStream in = Template.class.getResourceAsStream("default_shared_policies_template.xml");
                Template temp = TemplateManager.getTemplate(in);
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(temp.getXML());
                for (AbstractSchema schema : container.getChildren()) {
                    AdminDefinedScan scan;
                    AbstractSchema conObj;
                    SchemaContainer con = (SchemaContainer)schema;
                    Vector<AbstractSchema> childrean = con.getChildren();
                    if (childrean.size() <= 0 || !((conObj = childrean.get(0)) instanceof AdminDefinedScan) || !"FULL".equals((scan = (AdminDefinedScan)conObj).getScanTypeValue())) continue;
                    this.cachedAdminDefinedScan = scan;
                    break;
                }
            }
            catch (Exception e) {
                LoggerUtilities.logException(e);
            }
        }
        if (this.cachedAdminDefinedScan == null) {
            return null;
        }
        return this.cachedAdminDefinedScan.getOptApActions();
    }
}

