/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.valueobject;

import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;

public abstract class ValueObject
implements Serializable {
    private static final String NULL = "null";
    private static final long serialVersionUID = -2457941879510795923L;
    private transient Field[] classFields = null;

    protected ValueObject() {
        this.init();
    }

    public String toString() {
        return this.dumpFields();
    }

    private void init() {
        this.classFields = this.getClass().getDeclaredFields();
        if (this.classFields != null) {
            for (Field field : this.classFields) {
                field.setAccessible(true);
            }
        }
    }

    private String dumpFields() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        Object tempObj = null;
        buffer.append("==> ");
        if (this.classFields != null) {
            for (int i = 0; i < this.classFields.length; ++i) {
                if (i > 0) {
                    buffer.append("; ");
                }
                buffer.append(this.classFields[i].getName());
                buffer.append("=");
                try {
                    tempObj = this.classFields[i].get(this);
                }
                catch (IllegalAccessException a) {
                    buffer.append("not accessable");
                }
                if (tempObj == null) {
                    buffer.append(NULL);
                    continue;
                }
                if (tempObj.getClass().isArray()) {
                    try {
                        buffer.append(ValueObject.getArrayDescription((Object[])tempObj));
                    }
                    catch (ClassCastException cce) {
                        LoggerUtilities.logException(cce);
                    }
                    continue;
                }
                buffer.append(tempObj);
            }
        }
        buffer.append(" <==");
        return buffer.toString();
    }

    private static String getArrayDescription(Object[] objArray) {
        StringBuffer buffer = new StringBuffer(1024);
        for (Object obj : objArray) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            if (obj == null) {
                buffer.append(NULL);
                continue;
            }
            if (obj.getClass().isArray()) {
                buffer.append(ValueObject.getArrayDescription((Object[])obj));
                continue;
            }
            buffer.append(obj);
        }
        return buffer.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

