/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.valueobject;

import com.sygate.scm.common.valueobject.ValueObject;
import com.sygate.scm.util.StringUtilities;

public class JdbcParametersVO
extends ValueObject {
    private static final long serialVersionUID = -5524979719990962282L;
    private String jdbcDriverClass = null;
    private String jdbcUrl = null;
    private String userName = null;
    private String password = null;
    private String domain = null;
    private String mssqlSocketReadTimeout = null;

    public JdbcParametersVO() {
    }

    public JdbcParametersVO(String jdbcDriverClass, String jdbcUrl, String userName, String password) {
        this.jdbcDriverClass = jdbcDriverClass;
        this.jdbcUrl = jdbcUrl;
        this.userName = userName;
        this.password = password;
    }

    public JdbcParametersVO(String jdbcDriverClass, String jdbcUrl, String userName, String password, String domain, String mssqlSocketReadTime) {
        this(jdbcDriverClass, jdbcUrl, userName, password);
        this.domain = domain;
        this.mssqlSocketReadTimeout = mssqlSocketReadTime;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isNull() {
        return StringUtilities.isEmpty(this.jdbcDriverClass) || StringUtilities.isEmpty(this.jdbcUrl);
    }

    public String getMssqlSocketReadTimeout() {
        return this.mssqlSocketReadTimeout;
    }

    public void setMssqlSocketReadTimeout(String mssqlSocketReadTimeout) {
        this.mssqlSocketReadTimeout = mssqlSocketReadTimeout;
    }
}

