/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.valueobject;

import com.sygate.scm.common.configobject.schema.EmailServerConfig;
import com.sygate.scm.common.valueobject.ValueObject;
import com.sygate.scm.util.StringUtilities;
import java.util.Objects;

public class EmailServerSettingsVO
extends ValueObject {
    private static final long serialVersionUID = -7017015510840202082L;
    public static final int DEFAULT_SMTP_SERVER_PORT = 25;
    public static final int DEFAULT_SSL_SMTP_SERVER_PORT = 465;
    public static final int DEFAULT_TLS_SMTP_SERVER_PORT = 587;
    public static final int MAX_SMTP_SERVER_PORT = 65535;
    private String emailServerAddress;
    private String optionalServerDomain;
    private Integer emailServerPort;
    private String emailUsername;
    private transient String emailPassword;
    private String emailSender;
    private Boolean sslEnable;
    private Boolean tlsEnable;
    private Boolean disableCertValidation;

    public EmailServerSettingsVO(String emailServerAddress, Integer emailServerPort, String emailUsername, String emailPassword, String emailSender, Boolean sslEnable, Boolean tlsEnable, Boolean disableCertValidation) {
        this.emailServerAddress = emailServerAddress;
        this.emailServerPort = emailServerPort;
        this.emailUsername = emailUsername;
        this.emailPassword = emailPassword;
        this.emailSender = emailSender;
        this.sslEnable = sslEnable;
        this.tlsEnable = tlsEnable;
        this.disableCertValidation = disableCertValidation;
    }

    public EmailServerSettingsVO(String emailServerAddress, Integer emailServerPort) {
        this(emailServerAddress, emailServerPort, null);
    }

    public EmailServerSettingsVO(String emailServerAddress, Integer emailServerPort, String emailSender) {
        this(emailServerAddress, emailServerPort, null, null, emailSender, null, null, null);
    }

    public EmailServerSettingsVO() {
        this("", 25);
    }

    public EmailServerSettingsVO(EmailServerConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The parameter EmailServerConfig cannot be null!");
        }
        this.emailServerAddress = config.getSmtpServerAddress();
        this.emailServerPort = config.getOptSmtpServerPort();
        this.emailUsername = config.getOptUserName();
        this.emailPassword = config.getOptUserPassword();
        this.emailSender = config.getOptSenderAddress();
        this.sslEnable = config.getOptSSLConnection();
        this.tlsEnable = config.getOptTLSConnection();
        this.disableCertValidation = config.getOptDisableCertValidation();
    }

    public EmailServerSettingsVO(EmailServerSettingsVO vo) {
        if (vo == null) {
            throw new IllegalArgumentException("The parameter EmailServerSettingsVO cannot be null!");
        }
        this.emailServerAddress = vo.getEmailServerAddress();
        this.emailServerPort = vo.getEmailServerPort();
        this.emailUsername = vo.getEmailUsername();
        this.emailPassword = vo.getEmailPassword();
        this.emailSender = vo.getEmailSender();
        this.sslEnable = vo.getSslEnable();
        this.tlsEnable = vo.getTlsEnable();
        this.disableCertValidation = vo.getDisableCertValidation();
        this.optionalServerDomain = vo.getOptionalServerDomain();
    }

    public boolean isAuthenticatable() {
        return !StringUtilities.isEmpty(this.emailUsername);
    }

    public static long getSerialversionuid() {
        return -7017015510840202082L;
    }

    public String getEmailServerAddress() {
        return this.emailServerAddress;
    }

    public Integer getEmailServerPort() {
        if (this.isSslEnable()) {
            return this.emailServerPort == null ? Integer.valueOf(465) : this.emailServerPort;
        }
        if (this.isTlsEnable()) {
            return this.emailServerPort == null ? Integer.valueOf(587) : this.emailServerPort;
        }
        return this.emailServerPort == null ? Integer.valueOf(25) : this.emailServerPort;
    }

    public String getEmailUsername() {
        return this.emailUsername;
    }

    public String getEmailPassword() {
        return this.emailPassword;
    }

    public String getEmailSender() {
        return this.emailSender;
    }

    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    public Boolean getTlsEnable() {
        return this.tlsEnable;
    }

    public Boolean getDisableCertValidation() {
        return this.disableCertValidation;
    }

    public boolean isSslEnable() {
        return Objects.requireNonNullElse(this.sslEnable, new EmailServerConfig().getDefSSLConnection());
    }

    public boolean isTlsEnable() {
        return Objects.requireNonNullElse(this.tlsEnable, new EmailServerConfig().getDefTLSConnection());
    }

    public boolean isDisableCertValidation() {
        return Objects.requireNonNullElse(this.disableCertValidation, new EmailServerConfig().getDefDisableCertValidation());
    }

    public void setEmailSender(String emailSender) {
        this.emailSender = emailSender;
    }

    public void setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    public void setTlsEnable(Boolean tlsEnable) {
        this.tlsEnable = tlsEnable;
    }

    public void setDisableCertValidation(Boolean disableCertValidation) {
        this.disableCertValidation = disableCertValidation;
    }

    public void setEmailServerAddress(String emailServerAddress) {
        this.emailServerAddress = emailServerAddress;
    }

    public void setEmailServerPort(Integer emailServerPort) {
        this.emailServerPort = emailServerPort;
    }

    public void setEmailUsername(String emailUsername) {
        this.emailUsername = emailUsername;
    }

    public void setEmailPassword(String emailPassword) {
        this.emailPassword = emailPassword;
    }

    public String getOptionalServerDomain() {
        return this.optionalServerDomain;
    }

    public void setOptionalServerDomain(String emailServerDomain) {
        this.optionalServerDomain = emailServerDomain;
    }
}

