/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SqlServerCertificateDumper {
    private SSLEngine sslEngine = null;
    private TrustManager[] trustManagers = null;
    private Certificate sqlServerCertificate = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doHandshake(String host, int port) throws Exception {
        try (SocketChannel socket = this.createSocket(host, port);){
            this.sslEngine = this.createSslEngine(host, port);
            this.doPrelogin(socket);
            ByteBuffer netData = ByteBuffer.allocate(102400);
            ByteBuffer appData = ByteBuffer.allocate(102400);
            this.sslEngine.beginHandshake();
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            SSLEngineResult.Status status = null;
            block12: while (true) {
                switch (handshakeStatus) {
                    case NEED_WRAP: {
                        netData.clear();
                        if (this.sslEngine.wrap(ByteBuffer.allocate(0), netData).getStatus() == SSLEngineResult.Status.OK) {
                            netData.flip();
                            this.writeTdsPacket(socket, netData);
                            netData.clear();
                            netData.flip();
                        }
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block12;
                    }
                    case NEED_UNWRAP: {
                        if (status == null || status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            netData.compact();
                            this.readTdsPacket(socket, netData);
                        }
                        SSLEngineResult unwrapResult = this.sslEngine.unwrap(netData, appData);
                        handshakeStatus = unwrapResult.getHandshakeStatus();
                        status = unwrapResult.getStatus();
                        continue block12;
                    }
                    case NEED_TASK: {
                        Runnable task = null;
                        while ((task = this.sslEngine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) return;
                        continue block12;
                    }
                    case FINISHED: {
                        return;
                    }
                }
                break;
            }
            throw new Exception("Unexpected status: " + handshakeStatus);
        }
    }

    public Certificate getPeerCertificate() throws Exception {
        return this.sqlServerCertificate;
    }

    public TrustManager getTrustManager() {
        return this.trustManagers == null ? null : this.trustManagers[0];
    }

    private SocketChannel createSocket(String host, int port) throws IOException {
        SocketChannel socket = SocketChannel.open(new InetSocketAddress(host, port));
        socket.configureBlocking(false);
        return socket;
    }

    private SSLEngine createSslEngine(String host, int port) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        this.trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                if (chain.length > 0) {
                    SqlServerCertificateDumper.this.sqlServerCertificate = chain[0];
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        sslContext.init(null, this.trustManagers, null);
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        sslEngine.setUseClientMode(true);
        SSLParameters params = new SSLParameters();
        sslEngine.setSSLParameters(params);
        return sslEngine;
    }

    private void doPrelogin(SocketChannel socket) throws Exception {
        byte[] PRE_LOGIN_PACKET = new byte[]{18, 1, 0, 47, 0, 0, 1, 0, 0, 0, 26, 0, 6, 1, 0, 32, 0, 1, 2, 0, 33, 0, 1, 3, 0, 34, 0, 4, 4, 0, 38, 0, 1, -1, 9, 0, 0, 0, 0, 0, 1, 0, -72, 13, 0, 0, 1};
        ByteBuffer networkBuffer = ByteBuffer.allocate(1024);
        this.write(socket, ByteBuffer.wrap(PRE_LOGIN_PACKET));
        this.readTdsPacket(socket, networkBuffer);
    }

    private void writeTdsPacket(SocketChannel socket, ByteBuffer buffer) throws Exception {
        int totalSize = buffer.remaining() + 8;
        this.write(socket, ByteBuffer.wrap(new byte[]{18, 1, (byte)(totalSize >> 8 & 0xFF), (byte)(totalSize & 0xFF), 0, 0, 1, 0}));
        this.write(socket, buffer);
    }

    private void readTdsPacket(SocketChannel socket, ByteBuffer buffer) throws Exception {
        this.read(socket, buffer, 8);
        int bodySize = buffer.getShort(2) & 0xFFFF;
        int bytesToRead = bodySize - buffer.remaining();
        buffer.position(buffer.position() + 8);
        ByteBuffer packetBuffer = buffer.duplicate().position(buffer.limit()).limit(buffer.capacity());
        this.read(socket, packetBuffer, bytesToRead);
        buffer.limit(packetBuffer.limit());
    }

    private void read(SocketChannel socket, ByteBuffer buffer, int minSize) throws Exception {
        do {
            int readSize = socket.read(buffer);
            minSize -= readSize;
            if (readSize >= 0) continue;
            throw new Exception("Failed to read from socket");
        } while (minSize > 0 && buffer.hasRemaining());
        if (minSize > 0) {
            throw new Exception("Failed to read minimum size");
        }
        buffer.flip();
    }

    private void write(SocketChannel socket, ByteBuffer buffer) throws Exception {
        while (buffer.hasRemaining()) {
            if (socket.write(buffer) >= 0) continue;
            throw new Exception("Failed to write data to socket");
        }
    }
}

