/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import java.util.ArrayList;
import java.util.Vector;

public class SemGroupUtils {
    public static SemClientGroup getGroupById(SemClientGroupTree tree, String groupId) {
        if (tree == null || groupId == null || groupId.length() < 1) {
            return null;
        }
        SemClientGroup group = tree.getSemClientGroup();
        if (group.getId().equals(groupId)) {
            return group;
        }
        return SemGroupUtils.getGroupById(group, groupId);
    }

    private static SemClientGroup getGroupById(SemClientGroup parentGroup, String groupId) {
        if (parentGroup == null || groupId == null || groupId.length() < 1) {
            return null;
        }
        int count = parentGroup.getSemClientGroupCount();
        if (count < 1) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            SemClientGroup group = parentGroup.getSemClientGroup(i);
            if (group != null && groupId.equals(group.getId())) {
                return group;
            }
            SemClientGroup result = SemGroupUtils.getGroupById(group, groupId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ArrayList<SemClientGroup> getChildGroups(SemClientGroup parent) {
        ArrayList<SemClientGroup> list = new ArrayList<SemClientGroup>();
        SemGroupUtils.getChildGroups(list, parent);
        return list;
    }

    private static void getChildGroups(ArrayList<SemClientGroup> list, SemClientGroup parent) {
        Vector<SemClientGroup> groups = parent.getSemClientGroup();
        int len = groups.size();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            SemClientGroup group = groups.get(i);
            list.add(group);
            SemGroupUtils.getChildGroups(list, group);
        }
    }
}

