/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.BASHBPESettings;
import com.sygate.scm.common.configobject.schema.BASHConfidenceSettings;
import com.sygate.scm.common.configobject.schema.BASHHighConfidence;
import com.sygate.scm.common.configobject.schema.BASHLowConfidence;
import com.sygate.scm.common.configobject.schema.BASHPolicy;
import com.sygate.scm.common.configobject.schema.DiskTypes;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.configobject.schema.OptimizedMountScan;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.XPathSchemaUtil;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;

public class PolicyUtils {
    private static final MessageResourcesFile TEMPLATE_RES = new MessageResourcesFile("com.sygate.scm.util.template.template");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptimizedMountScan getDefaultOptimizedMountScan(StringBuffer sbuff) {
        OptimizedMountScan oms = null;
        String AvPolicyNameKey = "$$I18N.DefaultSPlcyTp.AvPolicy.NAME$$";
        try {
            boolean isSBE = "SEPSB".equals(LicenseUtils.getProductType());
            Template defaultPoliciesTmpl = TemplateManager.getDefaultSharedPolicyTemplate(isSBE);
            if (defaultPoliciesTmpl != null) {
                String defaultAvPolicyName = TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.AvPolicy.NAME$$");
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(defaultPoliciesTmpl.getXML());
                AvPolicy defAvPolicy = (AvPolicy)XPathSchemaUtil.xpath((AbstractSchema)container, "//AvPolicy[@Name=\"" + defaultAvPolicyName + "\"]");
                oms = defAvPolicy.getOptMacAvAutoProtect().getOptAvFileAp().getOptOptimizedMountScan();
            }
        }
        catch (Exception ex) {
            if (sbuff != null) {
                sbuff.append(ex.toString());
            }
        }
        finally {
            if (oms == null) {
                oms = new OptimizedMountScan();
            }
            if (oms.getOptDiskTypes() == null) {
                oms.setOptDiskTypes(PolicyUtils.getDefaultDiskTypeObjectForOptimizedMountScan());
            }
        }
        return oms;
    }

    public static IdsPolicy getDefaultIDSPolicyFromTemplate() {
        String idsPolicyNameKey = "$$I18N.DefaultSPlcyTp.IdsPolicy.NAME$$";
        IdsPolicy defIdsPolicy = null;
        try {
            Template defaultPoliciesTmpl = TemplateManager.getDefaultSharedPolicyTemplate(false);
            if (defaultPoliciesTmpl != null) {
                String defaultIdsPolicyName = TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.IdsPolicy.NAME$$");
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(defaultPoliciesTmpl.getXML());
                defIdsPolicy = (IdsPolicy)XPathSchemaUtil.xpath((AbstractSchema)container, "//IdsPolicy[@Name=\"" + defaultIdsPolicyName + "\"]");
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return defIdsPolicy;
    }

    public static MemPolicy getDefaultMemPolicyFromTemplate() {
        String memPolicyNameKey = "$$I18N.DefaultSPlcyTp.MemPolicy.NAME$$";
        MemPolicy defMemPolicy = null;
        try {
            Template defaultPoliciesTmpl = TemplateManager.getDefaultSharedPolicyTemplate(false);
            if (defaultPoliciesTmpl != null) {
                String defaultMemPolicyName = TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.MemPolicy.NAME$$");
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(defaultPoliciesTmpl.getXML());
                defMemPolicy = (MemPolicy)XPathSchemaUtil.xpath((AbstractSchema)container, "//MemPolicy[@Name=\"" + defaultMemPolicyName + "\"]");
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return defMemPolicy;
    }

    public static FwFirewallPolicy getFwPolicyByNameFromTemplate(String name) {
        FwFirewallPolicy fwPolicy = null;
        try {
            Template defaultPoliciesTmpl = TemplateManager.getDefaultSharedPolicyTemplate(false);
            if (defaultPoliciesTmpl != null) {
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(defaultPoliciesTmpl.getXML());
                fwPolicy = (FwFirewallPolicy)XPathSchemaUtil.xpath((AbstractSchema)container, "//FwFirewallPolicy[@Name=\"" + name + "\"]");
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return fwPolicy;
    }

    public static NtrPolicy getDefaultNtrPolicyFromTemplate() {
        String ntrPolicyNameKey = "$$I18N.DefaultSPlcyTp.NtrPolicy.NAME$$";
        NtrPolicy defNtrPolicy = null;
        try {
            Template defaultPoliciesTmpl = TemplateManager.getDefaultSharedPolicyTemplate(false);
            if (defaultPoliciesTmpl != null) {
                String defaultNtrPolicyName = TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NtrPolicy.NAME$$");
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(defaultPoliciesTmpl.getXML());
                defNtrPolicy = (NtrPolicy)XPathSchemaUtil.xpath((AbstractSchema)container, "//NtrPolicy[@Name=\"" + defaultNtrPolicyName + "\"]");
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return defNtrPolicy;
    }

    public static DiskTypes getDefaultDiskTypeObjectForOptimizedMountScan() {
        DiskTypes dt = new DiskTypes();
        dt.setOptDataDisk(true);
        dt.setOptAllOtherDisks(true);
        return dt;
    }

    public static String getPolicyTargetName(TopLevelObject policy) {
        String policyTargetName = null;
        switch (policy.getObjectType()) {
            case 839: {
                policyTargetName = "AdaptivePolicyApplied";
                break;
            }
            case 583: {
                policyTargetName = "AvPolicyApplied";
                break;
            }
            case 323: {
                policyTargetName = "FirewallPolicyApplied";
                break;
            }
            case 387: {
                policyTargetName = "HostIntegrityApplied";
                break;
            }
            case 469: {
                policyTargetName = "OpAppProtectionPolicyApplied";
                break;
            }
            case 706: {
                policyTargetName = "LuPolicyApplied";
                break;
            }
            case 697: {
                policyTargetName = "IdsPolicyApplied";
                break;
            }
            case 678: {
                policyTargetName = "PolicyOverrideApplied";
                break;
            }
            case 767: {
                policyTargetName = "TamperProtectionPolicyApplied";
                break;
            }
            case 835: {
                policyTargetName = "UpgradePolicyApplied";
                break;
            }
        }
        return policyTargetName;
    }

    public static void updateBASHOptionsInAvPolicy(BASHPolicy bashPolicy) {
        BASHBPESettings bpeSettings;
        bashPolicy.setOptEnabled(true);
        bashPolicy.setOptLocked(true);
        BASHConfidenceSettings confidenceSettings = bashPolicy.getOptBASHConfidenceSettings();
        if (confidenceSettings == null) {
            confidenceSettings = new BASHConfidenceSettings();
            bashPolicy.setOptBASHConfidenceSettings(confidenceSettings);
        }
        BASHHighConfidence bashHigh = confidenceSettings.getOptBASHHighConfidence();
        BASHLowConfidence bashLow = confidenceSettings.getOptBASHLowConfidence();
        if (bashHigh == null) {
            bashHigh = new BASHHighConfidence();
            confidenceSettings.setOptBASHHighConfidence(bashHigh);
        }
        if (bashLow == null) {
            bashLow = new BASHLowConfidence();
            confidenceSettings.setOptBASHLowConfidence(bashLow);
        }
        if ((bpeSettings = bashPolicy.getOptBASHBPESettings()) == null) {
            bpeSettings = new BASHBPESettings();
            bashPolicy.setOptBASHBPESettings(bpeSettings);
        }
        bpeSettings.setOptEnabled(true);
        bpeSettings.setOptLocked(true);
        if (BASHBPESettings.IGNORE.equals(bpeSettings.getHighConfidenceAction())) {
            bpeSettings.setHighConfidenceAction(BASHBPESettings.LOG);
        }
        if (BASHBPESettings.PROMPT.equals(bpeSettings.getHighConfidenceAction())) {
            bpeSettings.setHighConfidenceAction(BASHBPESettings.BLOCK);
        }
        if (BASHBPESettings.PROMPT.equals(bpeSettings.getLowConfidenceAction())) {
            bpeSettings.setLowConfidenceAction(BASHBPESettings.BLOCK);
        }
        if (BASHBPESettings.LOG.equals(bpeSettings.getHighConfidenceAction()) && !BASHBPESettings.LOG.equals(bpeSettings.getLowConfidenceAction()) && !BASHBPESettings.IGNORE.equals(bpeSettings.getLowConfidenceAction())) {
            bpeSettings.setLowConfidenceAction(BASHBPESettings.LOG);
        }
        if (BASHBPESettings.BLOCK.equals(bpeSettings.getHighConfidenceAction())) {
            bashHigh.setHighConfidenceAction(BASHHighConfidence.QUARANTINE);
        } else {
            bashHigh.setHighConfidenceAction(BASHHighConfidence.LOG);
        }
        if (BASHBPESettings.BLOCK.equals(bpeSettings.getLowConfidenceAction())) {
            bashLow.setLowConfidenceAction(BASHLowConfidence.QUARANTINE);
        } else if (BASHBPESettings.LOG.equals(bpeSettings.getLowConfidenceAction())) {
            bashLow.setLowConfidenceAction(BASHLowConfidence.LOG);
        } else {
            bashLow.setLowConfidenceAction(BASHLowConfidence.DISABLED);
        }
    }
}

