/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.CentralLuServer;
import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadRandomness;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.LuGeneralConfig;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.MacLuPolicy;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.util.DeterministicIdWasher;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.XPathSchemaUtil;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.util.Vector;

public class LUPolicyUtils {
    private static final String SYMANTEC_LU_SERVER = "SYMANTEC";
    private static final String INTERNAL_LU_SERVER = "INTERNAL";
    private static final MessageResourcesFile TEMPLATE_RES = new MessageResourcesFile("com.sygate.scm.util.template.template");

    public static LuPolicy retrieveDefaultLuPolicy() {
        boolean isSBE = false;
        String productType = LicenseUtils.getProductType();
        if ("SEPSB".equals(productType)) {
            isSBE = true;
        }
        Template defaultPoliciesTmpl = null;
        try {
            defaultPoliciesTmpl = TemplateManager.getDefaultSharedPolicyTemplate(isSBE);
        }
        catch (Exception e) {
            System.out.println("Exception reading default shared template: ");
            System.out.println(e);
        }
        if (defaultPoliciesTmpl == null) {
            System.out.println("retrieveDefaultLuPolicy: Error loading default shared template");
            return null;
        }
        LuPolicy defLuPolicy = null;
        try {
            String defaultLuPolicyName = TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.LuPolicy.NAME$$");
            String defaultLuPolicyName_SB = TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.LuPolicy.NAME$$");
            SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(defaultPoliciesTmpl.getXML());
            String name = isSBE ? defaultLuPolicyName_SB : defaultLuPolicyName;
            defLuPolicy = (LuPolicy)XPathSchemaUtil.xpath((AbstractSchema)container, "//LuPolicy[@Name=\"" + name + "\"]");
        }
        catch (Exception e) {
            System.out.println("Exception reading default shared template: ");
            System.out.println(e);
        }
        return defLuPolicy;
    }

    public static LuContentPolicy retrieveDefaultLuContentPolicy() {
        boolean isSBE = false;
        String productType = LicenseUtils.getProductType();
        if ("SEPSB".equals(productType)) {
            isSBE = true;
        }
        Template defaultPoliciesTmpl = null;
        try {
            defaultPoliciesTmpl = TemplateManager.getDefaultSharedPolicyTemplate(isSBE);
        }
        catch (Exception e) {
            System.out.println("Exception reading default shared template: ");
            System.out.println(e);
        }
        if (defaultPoliciesTmpl == null) {
            System.out.println("retrieveDefaultLuPolicy: Error loading default shared template");
            return null;
        }
        LuContentPolicy defLuContentPolicy = null;
        try {
            String defaultLuContentPolicyName = TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.LuContentPolicy.NAME$$");
            SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(defaultPoliciesTmpl.getXML());
            defLuContentPolicy = (LuContentPolicy)XPathSchemaUtil.xpath((AbstractSchema)container, "//LuContentPolicy[@Name=\"" + defaultLuContentPolicyName + "\"]");
        }
        catch (Exception e) {
            System.out.println("Exception reading default shared template: ");
            System.out.println(e);
        }
        return defLuContentPolicy;
    }

    private static LuPolicy getCloneOfLuPoliciesWithIdsReset(LuPolicy origLuPolicy) {
        if (origLuPolicy == null) {
            return null;
        }
        LuPolicy clone = (LuPolicy)origLuPolicy.clone();
        DeterministicIdWasher.resetLuPolicyIDs(clone, GUIDGenerator.getInstance().getGUIDString());
        return clone;
    }

    public static void copyLUSettingsFromWindowsToMacSection(LuPolicy winLuPolicyOrig, MacLuPolicy macLuPolicy) {
        if (winLuPolicyOrig == null || macLuPolicy == null) {
            return;
        }
        LuPolicy winLuPolicy = LUPolicyUtils.getCloneOfLuPoliciesWithIdsReset(winLuPolicyOrig);
        LuContentSourceInfo luContentSourceInfo = winLuPolicy.getOptLuContentSourceInfo();
        if (luContentSourceInfo != null) {
            boolean isUseLiveUpdateServer = true;
            macLuPolicy.getOptLuContentSourceInfo().setOptUseLiveUpdateServer(isUseLiveUpdateServer);
            try {
                if (luContentSourceInfo.getOptUseLiveUpdateServer() != null) {
                    isUseLiveUpdateServer = luContentSourceInfo.getOptUseLiveUpdateServer();
                }
            }
            catch (Exception e) {
                System.out.println("MacLUPolicyUpgrade::Exception occurred while fetching isUseLiveUpdateSettings" + e.getMessage());
            }
            macLuPolicy = LUPolicyUtils.copyCentralLUServers(macLuPolicy, luContentSourceInfo);
            if (isUseLiveUpdateServer) {
                LuDownloadSchedule luDownloadSchedule;
                LuGeneralConfig luGeneralConfig = winLuPolicy.getOptLuGeneralConfig();
                if (luGeneralConfig != null && macLuPolicy.getOptLuGeneralConfig() != null) {
                    macLuPolicy.getOptLuGeneralConfig().setOptAllowPatchByLiveUpdate(luGeneralConfig.getOptAllowPatchByLiveUpdate());
                    System.out.println("MacLUPolicyUpgrade::Upgrade Mac Lu Advanced Settings :: Use LiveUpdateServer" + isUseLiveUpdateServer);
                }
                if ((luDownloadSchedule = winLuPolicy.getOptLuDownloadSchedule()) != null) {
                    LuDownloadRandomness luDownloadRamdomness;
                    LuDownloadSchedule macLuDownloadSchedule;
                    macLuPolicy.setOptLuDownloadSchedule((LuDownloadSchedule)luDownloadSchedule.clone());
                    LuDownloadRandomness randomness = luDownloadSchedule.getOptLuDownloadRandomness();
                    if (randomness != null && randomness.getOptEnabled() == null && (macLuDownloadSchedule = macLuPolicy.getOptLuDownloadSchedule()) != null && (luDownloadRamdomness = macLuDownloadSchedule.getOptLuDownloadRandomness()) != null) {
                        luDownloadRamdomness.setOptEnabled(randomness.getDefEnabled());
                    }
                }
            }
        }
    }

    private static MacLuPolicy copyCentralLUServers(MacLuPolicy macLuPolicyInDB, LuContentSourceInfo luContentSourceInfo) {
        int centralServerCount = luContentSourceInfo.getCentralLuServerCount();
        if (centralServerCount != 0) {
            Vector<CentralLuServer> luCentralServers = luContentSourceInfo.getCentralLuServer();
            CentralLuServer server = null;
            CentralLuServer clonedServerObject = null;
            for (int count = 0; count < luCentralServers.size(); ++count) {
                server = luCentralServers.elementAt(count);
                clonedServerObject = (CentralLuServer)server.clone();
                macLuPolicyInDB.getOptLuContentSourceInfo().addCentralLuServer(clonedServerObject);
            }
        }
        System.out.println("MacLUPolicyUpgrade::Upgrade Mac LiveUpdate Servers Settings :: Central Liveupdate servers added = " + centralServerCount);
        try {
            macLuPolicyInDB.getOptLuContentSourceInfo().setOptLiveUpdateServerTypeValue(SYMANTEC_LU_SERVER);
            String liveUpdatevalue = luContentSourceInfo.getOptLiveUpdateServerTypeValue();
            if (INTERNAL_LU_SERVER.equals(liveUpdatevalue) && macLuPolicyInDB.getOptLuContentSourceInfo().getCentralLuServer().size() != 0) {
                macLuPolicyInDB.getOptLuContentSourceInfo().setOptLiveUpdateServerTypeValue(liveUpdatevalue);
            }
        }
        catch (ValidationException e) {
            System.out.println("MacLUPolicyUpgrade::Exception occurred while setting Live Update Server setting");
            LoggerUtilities.logException(e);
        }
        return macLuPolicyInDB;
    }

    public static LuAppliedContent retrieveClonedMacDefsContent(LuContentPolicy luCntPolicy, String contentCategory) {
        LuAppliedContent luAppCntForMac = null;
        LuAppliedContent tmpLuAppCnt = null;
        if (luCntPolicy != null) {
            int cntSize = luCntPolicy.getLuAppliedContentCount();
            for (int cnt = 0; cnt < cntSize; ++cnt) {
                tmpLuAppCnt = luCntPolicy.getLuAppliedContent(cnt);
                if (null == tmpLuAppCnt || !contentCategory.equals(tmpLuAppCnt.getContentCategory())) continue;
                luAppCntForMac = (LuAppliedContent)tmpLuAppCnt.clone();
                break;
            }
        }
        return luAppCntForMac;
    }

    public static LuAppliedContent retrieveDefsContent(LuContentPolicy luCntPolicy, String contentCategory) {
        LuAppliedContent luAppCnt = null;
        LuAppliedContent tmpLuAppCnt = null;
        if (luCntPolicy != null) {
            int cntSize = luCntPolicy.getLuAppliedContentCount();
            for (int cnt = 0; cnt < cntSize; ++cnt) {
                tmpLuAppCnt = luCntPolicy.getLuAppliedContent(cnt);
                if (null == tmpLuAppCnt || !contentCategory.equals(tmpLuAppCnt.getContentCategory())) continue;
                luAppCnt = tmpLuAppCnt;
                break;
            }
        }
        return luAppCnt;
    }
}

