/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.util.StringUtilities;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeManager {
    private static final String GMT = "GMT";
    private static final SimpleDateFormat DB_BACKUP_FILENAME_FORMAT = new SimpleDateFormat("yyyy-MMM-dd_kk-mm-ss");
    private static final SimpleDateFormat DB_BACKUP_FILENAME_FORMAT_BEFORE_AMBER = new SimpleDateFormat("yyyy-MMM-dd_hh-mm-ss-a");
    public static final String DAY = "dd";
    public static final String MONTH = "MM";
    public static final String YEAR = "yyyy";

    public static String getYYYYDigitalDate(long date) {
        return DateTimeManager.getYYYYDigitalDate(date, null);
    }

    public static String getYYYYDigitalDate(long date, TimeZone zone) {
        Date d = new Date(date);
        StringBuffer dateShort = new StringBuffer();
        StringBuffer dateMedium = new StringBuffer();
        FieldPosition yyfpShort = new FieldPosition(1);
        FieldPosition yyfpMedium = new FieldPosition(1);
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        DateFormat dateFormat_medium = DateFormat.getDateInstance(2);
        dateFormat.setTimeZone(TimeZone.getTimeZone(GMT));
        dateFormat_medium.setTimeZone(TimeZone.getTimeZone(GMT));
        if (zone != null) {
            dateFormat.setTimeZone(zone);
            dateFormat.format(d, dateShort, yyfpShort);
            dateFormat.setTimeZone(TimeZone.getTimeZone(GMT));
            dateFormat_medium.setTimeZone(zone);
            dateFormat_medium.format(d, dateMedium, yyfpMedium);
            dateFormat_medium.setTimeZone(TimeZone.getTimeZone(GMT));
        } else {
            dateFormat.format(d, dateShort, yyfpShort);
            dateFormat_medium.format(d, dateMedium, yyfpMedium);
        }
        return dateShort.replace(yyfpShort.getBeginIndex(), yyfpShort.getEndIndex(), dateMedium.toString().substring(yyfpMedium.getBeginIndex(), yyfpMedium.getEndIndex())).toString();
    }

    public static String getFullDigitalDate(long date) {
        DateFormat df = DateFormat.getDateTimeInstance();
        return df.format(date);
    }

    public static String getLicenseExpirationDate(long date) {
        SimpleDateFormat dateformat_GMT = new SimpleDateFormat("z");
        return StringUtilities.join(DateTimeManager.getFullDigitalDate(date), " ", dateformat_GMT.format(new Date(date)));
    }

    public static String formatAlertTime(long date) {
        SimpleDateFormat dateformat_GMT = new SimpleDateFormat("z");
        return StringUtilities.join(DateTimeManager.getFullDigitalDate(date), " ", dateformat_GMT.format(new Date(date)));
    }

    public static String getLocalTimeZone() {
        SimpleDateFormat dateformat_GMT = new SimpleDateFormat("z");
        return dateformat_GMT.format(new Date());
    }

    public static DateFormat getFormatOfDBBackupFilename() {
        return DB_BACKUP_FILENAME_FORMAT;
    }

    public static DateFormat getFormatOfDBBackupTime() {
        return new SimpleDateFormat("yyyy-MMM-dd kk:mm:ss");
    }

    public static DateFormat getFormatOfDBBackupFilenameBeforeAmber() {
        return DB_BACKUP_FILENAME_FORMAT_BEFORE_AMBER;
    }

    public static String getDateFormat() {
        String format = "MM/dd/yyyy";
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        StringBuffer dateShort = new StringBuffer();
        FieldPosition yyfpShort = new FieldPosition(1);
        dateFormat.format(new Date(0L), dateShort, yyfpShort);
        int yyBegin = yyfpShort.getBeginIndex();
        dateFormat = DateFormat.getDateInstance(3);
        dateShort = new StringBuffer();
        FieldPosition mmfpShort = new FieldPosition(2);
        dateFormat.format(new Date(0L), dateShort, mmfpShort);
        int mmBegin = mmfpShort.getBeginIndex();
        format = yyBegin == 0 ? (mmBegin == 3 ? "yyyy/MM/dd" : "yyyy/dd/MM") : (mmBegin == 0 ? (yyBegin == 3 ? "MM/yyyy/dd" : "MM/dd/yyyy") : (mmBegin == 3 ? "dd/MM/yyyy" : "dd/yyyy/MM"));
        return format;
    }
}

