/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.util.AutoClose;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationSummaryInfo {
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.util.util");
    public static final String TITLE = MSG_RES.getString("ConfigSummaryInfo.tileText");
    public static final String SITE_NAME = MSG_RES.getString("ConfigSummaryInfo.lblSiteName");
    public static final String SERVER_NAME = MSG_RES.getString("ConfigSummaryInfo.lblServerName");
    public static final String SERVER_PORT = MSG_RES.getString("ConfigSummaryInfo.lblServerPort");
    public static final String WEB_CONSOLE_PORT = MSG_RES.getString("ConfigSummaryInfo.lblRemotePort");
    public static final String CLIENT_COMMUNICATION_PORT = MSG_RES.getString("ConfigSummaryInfo.lblWebserverPort");
    public static final String CLIENT_COMMUNICATION_PORT_HTTPS = MSG_RES.getString("ConfigSummaryInfo.lblWebserverPortHttps");
    public static final String RMM_WEBSERVICE_PORT = MSG_RES.getString("ConfigSummaryInfo.lblRmmWebServicesPort");
    public static final String PROCESS_LAUNCHER_PORT = MSG_RES.getString("ConfigSummaryInfo.lblLaunchServicePort");
    public static final String SERVER_CONTROL_PORT = MSG_RES.getString("ConfigSummaryInfo.lblServerControlPort");
    public static final String REPORTING_PORT = MSG_RES.getString("ConfigSummaryInfo.lblConsoleReportingHTTPSPort");
    public static final String DATABASE_TYPE = MSG_RES.getString("ConfigSummaryInfo.lblDatabaseType");
    public static final String DATABASE_TYPE_EMBEDDED = MSG_RES.getString("SMBWizard.Embedded");
    public static final String DATABASE_TYPE_SQL = MSG_RES.getString("SMBWizard.MSSQL");
    public static final String DATABASE_NAME = MSG_RES.getString("ConfigSummaryInfo.lblDatabaseName");
    public static final String USER_NAME = MSG_RES.getString("ConfigSummaryInfo.lblAdminUser");
    public static final String EMAIL_ADDRESS = MSG_RES.getString("ConfigSummaryInfo.lblAdminEmail");
    public static final String SEPM_CONFIG_SUMMARY_INFO_FILE = "SEPMConfigurationSummaryInfo.txt";
    public static final String SEPM_CONFIG_SUMMARY_INFO_FILE_TEMP = "SEPMConfigurationSummaryInfo-temp.txt";
    private static String serverHome = null;
    private static String sepmConfigSummaryInfoFilePath = null;
    private CONFIG_CHANGE_USECASE configChangeUseCase;
    private Map<CONFIG_CHANGE_USECASE, String> configChangeUseCaseMap = new HashMap<CONFIG_CHANGE_USECASE, String>();
    private static final String UNKNOWN_USE_CASE = "Unknown";
    private static final String FRESH_INSTALL_USE_CASE = "Fresh Install";
    private static final String RECONFIG_USE_CASE = "Reconfig";
    private static final String ADD_SERVER_USE_CASE = "Add Server";
    private static final String ADD_SITE_USE_CASE = "Add Site";
    private static final String UPGRADE_USE_CASE = "Upgrade";
    private final String originalFile = sepmConfigSummaryInfoFilePath + File.separator + "SEPMConfigurationSummaryInfo.txt";
    private final String renamedFile = sepmConfigSummaryInfoFilePath + File.separator + "SEPMConfigurationSummaryInfo-temp.txt";

    public ConfigurationSummaryInfo(CONFIG_CHANGE_USECASE useCase) {
        this.configChangeUseCaseMap.put(CONFIG_CHANGE_USECASE.UNKNOWN, UNKNOWN_USE_CASE);
        this.configChangeUseCaseMap.put(CONFIG_CHANGE_USECASE.FRESH_INSTALL, FRESH_INSTALL_USE_CASE);
        this.configChangeUseCaseMap.put(CONFIG_CHANGE_USECASE.ADD_SERVER, ADD_SERVER_USE_CASE);
        this.configChangeUseCaseMap.put(CONFIG_CHANGE_USECASE.ADD_SITE, ADD_SITE_USE_CASE);
        this.configChangeUseCaseMap.put(CONFIG_CHANGE_USECASE.RECONFIG, RECONFIG_USE_CASE);
        this.configChangeUseCaseMap.put(CONFIG_CHANGE_USECASE.UPGRADE, UPGRADE_USE_CASE);
        this.configChangeUseCase = useCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(HashMap<String, String> configurationInfo) {
        boolean success = false;
        try {
            System.out.println("ConfigurationSummaryInfo> save>> Configuration change use case = " + this.configChangeUseCaseMap.get((Object)this.configChangeUseCase));
            if (this.configChangeUseCase.equals((Object)CONFIG_CHANGE_USECASE.FRESH_INSTALL) || this.configChangeUseCase.equals((Object)CONFIG_CHANGE_USECASE.RECONFIG) || this.configChangeUseCase.equals((Object)CONFIG_CHANGE_USECASE.UPGRADE)) {
                this.renameExistingFile(this.originalFile, this.renamedFile);
                this.writeConfigSummary(configurationInfo, this.originalFile, this.renamedFile);
                success = true;
            }
        }
        catch (Throwable t) {
            System.out.println("ConfigurationSummaryInfo> save>> Failed to write SEPM configuration details summary. Error: " + t.getMessage());
            LoggerUtilities.logException(t);
        }
        finally {
            if (success) {
                try {
                    File newFile = new File(this.renamedFile);
                    boolean deleted = newFile.delete();
                    System.out.println("ConfigurationSummaryInfo> save>> Deleting temp file. Is deleted? " + deleted);
                }
                catch (Throwable t) {
                    System.out.println("ConfigurationSummaryInfo> save>> Failed to delete temp file. Error: " + t.getMessage());
                    LoggerUtilities.logException(t);
                }
            } else {
                this.renameExistingFile(this.renamedFile, this.originalFile);
            }
        }
        return success;
    }

    public boolean isSummaryFileExitsing() {
        return new File(this.originalFile).exists();
    }

    public String getRenamedFileName() {
        return this.renamedFile;
    }

    private boolean writeConfigSummary(HashMap<String, String> configurationInfo, String fileName, String renamedFileName) {
        boolean success = false;
        try (AutoClose<BufferedWriter> fileWriter = IOUtilities.getAutoCloseWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), "UTF-8")));){
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder buffer = new StringBuilder();
            buffer.append(TITLE);
            buffer.append(lineSeparator);
            buffer.append("----------------------------------------------------------------");
            if (configurationInfo.containsKey(SITE_NAME)) {
                buffer.append(lineSeparator);
                buffer.append(SITE_NAME + "                              : ");
                buffer.append(configurationInfo.get(SITE_NAME));
            }
            if (configurationInfo.containsKey(SERVER_NAME)) {
                buffer.append(lineSeparator);
                buffer.append(SERVER_NAME + "                            : ");
                buffer.append(configurationInfo.get(SERVER_NAME));
            }
            if (configurationInfo.containsKey(SERVER_PORT)) {
                buffer.append(lineSeparator);
                buffer.append(SERVER_PORT + "                            : ");
                buffer.append(configurationInfo.get(SERVER_PORT));
            }
            if (configurationInfo.containsKey(WEB_CONSOLE_PORT)) {
                buffer.append(lineSeparator);
                buffer.append(WEB_CONSOLE_PORT + "                       : ");
                buffer.append(configurationInfo.get(WEB_CONSOLE_PORT));
            }
            if (configurationInfo.containsKey(CLIENT_COMMUNICATION_PORT)) {
                buffer.append(lineSeparator);
                buffer.append(CLIENT_COMMUNICATION_PORT + "      : ");
                buffer.append(configurationInfo.get(CLIENT_COMMUNICATION_PORT));
            }
            if (configurationInfo.containsKey(CLIENT_COMMUNICATION_PORT_HTTPS)) {
                buffer.append(lineSeparator);
                buffer.append(CLIENT_COMMUNICATION_PORT_HTTPS + "     : ");
                buffer.append(configurationInfo.get(CLIENT_COMMUNICATION_PORT_HTTPS));
            }
            if (configurationInfo.containsKey(RMM_WEBSERVICE_PORT)) {
                buffer.append(lineSeparator);
                buffer.append(RMM_WEBSERVICE_PORT + "    : ");
                buffer.append(configurationInfo.get(RMM_WEBSERVICE_PORT));
            }
            if (configurationInfo.containsKey(PROCESS_LAUNCHER_PORT)) {
                buffer.append(lineSeparator);
                buffer.append(PROCESS_LAUNCHER_PORT + "                  : ");
                buffer.append(configurationInfo.get(PROCESS_LAUNCHER_PORT));
            }
            if (configurationInfo.containsKey(SERVER_CONTROL_PORT)) {
                buffer.append(lineSeparator);
                buffer.append(SERVER_CONTROL_PORT + "                    : ");
                buffer.append(configurationInfo.get(SERVER_CONTROL_PORT));
            }
            if (configurationInfo.containsKey(REPORTING_PORT)) {
                buffer.append(lineSeparator);
                buffer.append(REPORTING_PORT + "                         : ");
                buffer.append(configurationInfo.get(REPORTING_PORT));
            }
            if (configurationInfo.containsKey(DATABASE_TYPE)) {
                buffer.append(lineSeparator);
                buffer.append(DATABASE_TYPE + "                          : ");
                buffer.append(configurationInfo.get(DATABASE_TYPE));
            }
            if (configurationInfo.containsKey(DATABASE_NAME)) {
                buffer.append(lineSeparator);
                buffer.append(DATABASE_NAME + "                          : ");
                buffer.append(configurationInfo.get(DATABASE_NAME));
            }
            if (configurationInfo.containsKey(USER_NAME)) {
                buffer.append(lineSeparator);
                buffer.append(USER_NAME + "                              : ");
                buffer.append(configurationInfo.get(USER_NAME));
            }
            if (configurationInfo.containsKey(EMAIL_ADDRESS)) {
                buffer.append(lineSeparator);
                buffer.append(EMAIL_ADDRESS + "                          : ");
                buffer.append(configurationInfo.get(EMAIL_ADDRESS));
            }
            ((Writer)fileWriter.getObject()).write(buffer.toString());
            ((Writer)fileWriter.getObject()).flush();
            success = true;
            System.out.println("ConfigurationSummaryInfo> writeConfigSummary>> Written server configuration details into file.");
        }
        catch (Throwable t) {
            System.out.println("ConfigurationSummaryInfo> writeConfigSummary>> Failed to write server configuration details into file. Error: " + t.getMessage());
            LoggerUtilities.logException(t);
        }
        return success;
    }

    private boolean renameExistingFile(String oldFileName, String newFileName) {
        boolean success = false;
        try {
            File newFile = new File(newFileName);
            if (newFile.exists()) {
                boolean deleted = newFile.delete();
                System.out.println("ConfigurationSummaryInfo> renameExistingFile>> File (" + newFileName + ") exists. Is deleted? " + deleted);
            }
            File oldFile = new File(oldFileName);
            success = oldFile.renameTo(newFile);
            System.out.println("ConfigurationSummaryInfo> renameExistingFile>> Existing Configuration file renamed.");
        }
        catch (Throwable t) {
            System.out.println("ConfigurationSummaryInfo> renameExistingFile>> Failed to rename existing file. Error: " + t.getMessage());
            LoggerUtilities.logException(t);
        }
        return success;
    }

    static {
        serverHome = System.getProperty("catalina.home");
        if (serverHome == null || serverHome.length() == 0) {
            System.out.println("ConfigurationSummaryInfo> Missing system property. Invalid server home. serverHome: " + serverHome);
        } else {
            sepmConfigSummaryInfoFilePath = serverHome + File.separator + "etc";
        }
    }

    public static enum CONFIG_CHANGE_USECASE {
        UNKNOWN(0),
        FRESH_INSTALL(1),
        RECONFIG(2),
        ADD_SERVER(3),
        ADD_SITE(4),
        UPGRADE(5);

        private final int value;

        private CONFIG_CHANGE_USECASE(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

