/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.util.StringUtilities;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.xml.sax.SAXException;

public class ConfigObjectUtils {
    public static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static int sweepObsoleteItems(ConfigObject co, long checkPoint) {
        int deletedSum = 0;
        int timeUpdatedSum = 0;
        int count = co.getObsoleteItemCount();
        if (count > 0) {
            for (int i = count - 1; i >= 0; --i) {
                ObsoleteItem item = co.getObsoleteItem(i);
                if (item.getDeletedT() == -1L) {
                    item.setDeletedT(TimeUtil.getServerTime());
                    ++timeUpdatedSum;
                    continue;
                }
                if (item.getDeletedT() >= checkPoint) continue;
                co.removeObsoleteItem(item);
                ++deletedSum;
            }
        }
        for (AbstractSchema o : co.getChildren()) {
            ConfigObject child = (ConfigObject)o;
            deletedSum += ConfigObjectUtils.sweepObsoleteItems(child, checkPoint);
        }
        if (deletedSum > 0 || timeUpdatedSum > 0) {
            co.setDirty();
        }
        return deletedSum;
    }

    public static boolean isEqualObj(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        if (obj1 instanceof AbstractSchema) {
            return ConfigObjectUtils.isEqualSchemaObj((AbstractSchema)obj1, (AbstractSchema)obj2);
        }
        if (obj1 instanceof Vector) {
            return ConfigObjectUtils.isEqualVector((Vector)obj1, (Vector)obj2);
        }
        return obj1.equals(obj2);
    }

    private static boolean isEqualSchemaObj(AbstractSchema obj1, AbstractSchema obj2) {
        Vector<AbstractSchema> v_that;
        Field[] fields;
        Class<?> cls = obj1.getClass();
        for (Field field : fields = cls.getDeclaredFields()) {
            String fieldName = ConfigObjectUtils.makeFirstCharUpper(field.getName());
            Method get = ConfigObjectUtils.getGetMethod(cls, fieldName);
            if (get == null) {
                get = ConfigObjectUtils.getGetOptMethod(cls, fieldName);
            }
            if (get == null) continue;
            Method getDef = ConfigObjectUtils.getGetDefMethod(cls, fieldName);
            Object value1 = ConfigObjectUtils.getFieldValue(get, getDef, obj1);
            Object value2 = ConfigObjectUtils.getFieldValue(get, getDef, obj2);
            if (field.getType().equals(String.class)) {
                value1 = ConfigObjectUtils.prepareString((String)value1);
                value2 = ConfigObjectUtils.prepareString((String)value2);
            }
            if ("content".equalsIgnoreCase(field.getName()) && cls.equals(UnknownContent.class)) {
                value1 = ConfigObjectUtils.parseUnknownContent((byte[])value1);
                value2 = ConfigObjectUtils.parseUnknownContent((byte[])value2);
            }
            if (ConfigObjectUtils.isEqualObj(value1, value2)) continue;
            return false;
        }
        Vector<AbstractSchema> v_this = obj1.getChildren();
        return ConfigObjectUtils.isEqualVector(v_this, v_that = obj2.getChildren());
    }

    private static Object parseUnknownContent(byte[] buf) {
        if (buf != null) {
            try {
                return AbstractSchema.readXML(buf);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        return buf;
    }

    private static String prepareString(String value) {
        if (value != null) {
            return value.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        }
        return "";
    }

    private static Object getFieldValue(Method get, Method getDef, Object obj) {
        Object value = null;
        try {
            value = get.invoke(obj, new Object[0]);
            if (value == null && getDef != null) {
                value = getDef.invoke(obj, new Object[0]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return value;
    }

    private static String makeFirstCharUpper(String fieldName) {
        if (StringUtilities.isEmpty(fieldName)) {
            return "";
        }
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static Method getGetMethod(Class<?> cls, String fieldName) {
        String methodName = "get" + fieldName;
        try {
            return cls.getMethod(methodName, new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Method getGetOptMethod(Class<?> cls, String fieldName) {
        String methodName = "getOpt" + fieldName;
        try {
            return cls.getMethod(methodName, new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Method getGetDefMethod(Class<?> cls, String fieldName) {
        String methodName = "getDef" + fieldName;
        try {
            return cls.getMethod(methodName, new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isEqualVector(Vector<?> v1, Vector<?> v2) {
        if (v1.size() != v2.size()) {
            return false;
        }
        for (int i = 0; i < v1.size(); ++i) {
            Object group2;
            Object group1 = v1.get(i);
            if (ConfigObjectUtils.isEqualObj(group1, group2 = v2.get(i))) continue;
            return false;
        }
        return true;
    }
}

