/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.HTMLEditorPane;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class CommonUtilities {
    public static void layoutButtonPanel(JPanel jButtonPanel, JButton[] jButtons, int directory, int alignment, boolean isFitButtons) {
        CommonUtilities.layoutButtonPanel(jButtonPanel, jButtons, directory, alignment, isFitButtons, true, 3);
    }

    public static void centerDlg(Window dlg) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = dlg.getSize();
        if (dlgSize.height > screenSize.height) {
            dlgSize.height = screenSize.height;
        }
        if (dlgSize.width > screenSize.width) {
            dlgSize.width = screenSize.width;
        }
        dlg.setLocation((screenSize.width - dlgSize.width) / 2, (screenSize.height - dlgSize.height) / 2);
    }

    public static void showErrorMessage(Component parent, String title, String message) {
        CommonUtilities.showMessage(parent, title, message, 0);
    }

    public static void showInformationMessage(Component parent, String title, String message) {
        CommonUtilities.showMessage(parent, title, message, 1);
    }

    public static int showWarningMessageWithKBLink(Component parent, String resFileName, String kbURLHeadingKey, String titleKey, String messageKey, String[] userChoiceLabels, ImageIcon imageIcon, boolean useSpecificErrorCodeKBURL, String errorCodeStr, int optionType) {
        return CommonUtilities.showMessage(parent, resFileName, kbURLHeadingKey, titleKey, messageKey, userChoiceLabels, imageIcon, useSpecificErrorCodeKBURL, errorCodeStr, optionType, 2);
    }

    public static JEditorPane getKBLinkPane(String displayText, String kbUrl) {
        if (displayText == null || kbUrl == null) {
            throw new IllegalArgumentException();
        }
        String text = "<html>" + UIFontUtilities.HTML_CSS + "  <a href='" + kbUrl + "' style='cursor:hand'>" + displayText + "</a></html>";
        JEditorPane pane = new JEditorPane();
        pane.setFocusable(false);
        pane.setOpaque(false);
        pane.setContentType("text/html");
        pane.setText(text);
        pane.setEditable(false);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String strURL = e.getURL().toString();
                    URLUtility.browseURI(strURL);
                }
            }
        });
        return pane;
    }

    public static JEditorPane getMoreDetailsPane(String displayText) {
        if (displayText == null) {
            throw new IllegalArgumentException();
        }
        String text = "<html>" + UIFontUtilities.HTML_CSS + "  <a href='" + displayText + "' style='cursor:hand'>" + displayText + "</a></html>";
        JEditorPane pane = new JEditorPane();
        pane.setFocusable(false);
        pane.setOpaque(false);
        pane.setContentType("text/html");
        pane.setText(text);
        pane.setEditable(false);
        return pane;
    }

    private static void layoutButtonPanel(JPanel jButtonPanel, JButton[] jButtons, int directory, int alignment, boolean isFitButtons, boolean hasBorder, int strutSize) {
        if (isFitButtons) {
            CommonUtilities.fitJComponent(jButtons);
        }
        jButtonPanel.setOpaque(false);
        jButtonPanel.setLayout(new BoxLayout(jButtonPanel, directory));
        if (hasBorder) {
            jButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        }
        if (directory == 0 && alignment != 2 || directory == 1 && alignment != 1) {
            jButtonPanel.add(Box.createGlue());
        }
        for (int i = 0; i < jButtons.length; ++i) {
            if (i != 0) {
                Component strut = directory == 0 ? Box.createHorizontalStrut(strutSize) : Box.createVerticalStrut(strutSize);
                jButtonPanel.add(strut);
            }
            jButtons[i].setAlignmentY(1.0f);
            jButtonPanel.add(jButtons[i]);
        }
        if (directory == 0 && alignment != 4 || directory == 1 && alignment != 3) {
            jButtonPanel.add(Box.createGlue());
        }
    }

    private static void fitJComponent(JComponent[] components) {
        int i;
        int width = 0;
        int height = 0;
        for (i = 0; i < components.length; ++i) {
            Dimension d = components[i].getPreferredSize();
            width = (int)Math.max(d.getWidth(), (double)width);
            height = (int)Math.max(d.getHeight(), (double)height);
        }
        for (i = 0; i < components.length; ++i) {
            components[i].setPreferredSize(new Dimension(width, height));
            components[i].setMaximumSize(new Dimension(width, height));
        }
    }

    private static int showMessage(Component parent, String resFileName, String kbURLHeadingKey, String titleKey, String messageKey, String[] userChoiceLabels, ImageIcon imageIcon, boolean useSpecificErrorCodeKBURL, String errorCodeStr, int optionType, int messageType) {
        MessageResourcesFile res = new MessageResourcesFile(resFileName);
        String knowledgeBaseURLLink = MessageFormat.format(CommonUtilities.getSEPMKBLinkURL(useSpecificErrorCodeKBURL), ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage(), errorCodeStr);
        String knowledgeBaseURLHeading = res.getString(kbURLHeadingKey);
        String setServicePrivilegeFailedWarningMessage = res.getString(messageKey, knowledgeBaseURLLink, knowledgeBaseURLHeading);
        String title = res.getString(titleKey);
        HTMLEditorPane htmlEditorPane = new HTMLEditorPane(parent);
        htmlEditorPane.setText(setServicePrivilegeFailedWarningMessage);
        ArrayList<String> userOptions = new ArrayList<String>();
        if (userChoiceLabels != null && userChoiceLabels.length > 0) {
            for (String userChoiceLabel : userChoiceLabels) {
                userOptions.add(res.getString(userChoiceLabel));
            }
        }
        Object[] options = userOptions.size() == 0 ? null : userOptions.toArray();
        Object userOption = null;
        if (options != null) {
            userOption = options[0];
        }
        return JOptionPane.showOptionDialog(parent, htmlEditorPane, title, optionType, messageType, imageIcon, options, userOption);
    }

    private static String getSEPMKBLinkURL(boolean useSpecifcErrorCodeURL) {
        ResourceBundle resourceBundle = MessageResources.getResourceBundle("com.sygate.scm.common.ui.ui");
        String kbURLLinkKey = "";
        kbURLLinkKey = "Symantec.endpoint.protection.management.doc.knowledgeBase.url";
        if (useSpecifcErrorCodeURL) {
            kbURLLinkKey = "Symantec.endpoint.protection.management.doc.knowledgeBase.urlForSpecificErrorCode";
        }
        return resourceBundle.getString(kbURLLinkKey);
    }

    private static void showMessage(Component parent, String title, String message, int messageType) {
        int msgLength = 0;
        int columnSize = 40;
        if (message != null) {
            msgLength = message.length();
        }
        if (msgLength > 120) {
            columnSize = 60;
        }
        JTextArea textArea = new JTextArea();
        textArea.setColumns(columnSize);
        textArea.setOpaque(false);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setAlignmentX(0.0f);
        textArea.setSize(textArea.getPreferredSize());
        textArea.setText(message);
        JOptionPane.showMessageDialog(parent, textArea, title, messageType);
    }
}

