/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.ini.IniFile;
import com.sygate.scm.util.ini.IniProperty;
import com.sygate.scm.util.ini.IniSection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.zip.ZipFile;

public class ClientPackageUtils {

    public static class SetAidIni {
        private static final String SECTION_PREDEFINED_SMC_CONFIG = "PREDEFINED_SMC_CONFIG";
        private static final String SECTION_LU_CONFIG = "LU_CONFIG";
        private static final String PROPERTITY_PACKAGECHECKSUM = "PackageChecksum";
        private static final String PROPERTITY_APPTYPE = "AppType";
        private static final String PROPERTITY_PLATFORMTYPE = "PlatformType";
        private static final String PROPERTITY_SERVERMONIKER = "ServerMoniker";
        private static final String PROPERTITY_SERVERPRODUCT = "ServerProduct";
        private static final String PROPERTITY_SERVERVERSION = "ServerVersion";
        private static final String PROPERTITY_SERVERLANGUAGE = "ServerLanguage";
        private static final String PROPERTITY_CLIENTMONIKER = "ClientMoniker";
        private static final String PROPERTITY_CLIENTPRODUCT = "ClientProduct";
        private static final String PROPERTITY_CLIENTVERSION = "ClientVersion";
        private static final String PROPERTITY_CLIENTLANGUAGE = "ClientLanguage";
        private static final String PROPERTITY_LANGUAGE = "Language";
        private static final String PROPERTITY_DISPLAYNAME = "DisplayName";
        private static final String PROPERTITY_DISTRIBUTABLE = "Distributable";
        private static final String DEFAULT_VALUE_DISTRIBUTABLE = "0";
        private static final String DISTRIBUTABLE_TRUE = "1";
        String appType;
        String platformType;
        String serverMoniker;
        String serverProduct;
        String serverVersion;
        String serverLanguage;
        String clientMoniker;
        String clientProduct;
        String clientVersion;
        String clientLanguage;
        String language;
        String packageChecksum;
        String displayName;
        String distributable;
        IniFile file = new IniFile();

        public SetAidIni(String setAidFilePath) throws Exception {
            boolean readResult;
            try (ZipFile zipFile = new ZipFile((String)setAidFilePath);){
                System.out.println("SetAidIni >> It's a zip file, " + zipFile.getName());
                readResult = this.file.read((String)setAidFilePath, "setAid.ini", null);
            }
            catch (IOException e) {
                if (Files.isDirectory(Paths.get((String)setAidFilePath, new String[0]), new LinkOption[0])) {
                    setAidFilePath = (String)setAidFilePath + File.separator + "setAid.ini";
                }
                readResult = this.file.read((String)setAidFilePath);
            }
            if (readResult) {
                this.packageChecksum = this.file.getProperty(SECTION_PREDEFINED_SMC_CONFIG, PROPERTITY_PACKAGECHECKSUM);
                if (StringUtilities.isEmpty(this.packageChecksum)) {
                    throw new Exception("Cannot read packageChecksum from file " + (String)setAidFilePath);
                }
                this.appType = this.file.getProperty(SECTION_PREDEFINED_SMC_CONFIG, PROPERTITY_APPTYPE);
                if (StringUtilities.isEmpty(this.appType)) {
                    throw new Exception("Cannot read appType from file " + (String)setAidFilePath);
                }
                this.platformType = this.file.getProperty(SECTION_PREDEFINED_SMC_CONFIG, PROPERTITY_PLATFORMTYPE);
                if (StringUtilities.isEmpty(this.platformType)) {
                    throw new Exception("Cannot read platformType from file " + (String)setAidFilePath);
                }
                this.serverMoniker = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_SERVERMONIKER);
                if (StringUtilities.isEmpty(this.serverMoniker)) {
                    throw new Exception("Cannot read serverMoniker from file " + (String)setAidFilePath);
                }
                this.serverProduct = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_SERVERPRODUCT);
                if (StringUtilities.isEmpty(this.serverProduct)) {
                    throw new Exception("Cannot read serverProduct from file " + (String)setAidFilePath);
                }
                this.serverVersion = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_SERVERVERSION);
                if (StringUtilities.isEmpty(this.serverVersion)) {
                    throw new Exception("Cannot read serverVersion from file " + (String)setAidFilePath);
                }
                this.serverLanguage = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_SERVERLANGUAGE);
                if (StringUtilities.isEmpty(this.serverLanguage)) {
                    throw new Exception("Cannot read serverLanguage from file " + (String)setAidFilePath);
                }
                this.clientMoniker = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_CLIENTMONIKER);
                if (StringUtilities.isEmpty(this.clientMoniker)) {
                    throw new Exception("Cannot read clientMoniker from file " + (String)setAidFilePath);
                }
                this.clientProduct = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_CLIENTPRODUCT);
                if (StringUtilities.isEmpty(this.clientProduct)) {
                    throw new Exception("Cannot read clientProduct from file " + (String)setAidFilePath);
                }
                this.clientVersion = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_CLIENTVERSION);
                if (StringUtilities.isEmpty(this.clientVersion)) {
                    throw new Exception("Cannot read clientVersion from file " + (String)setAidFilePath);
                }
                this.clientLanguage = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_CLIENTLANGUAGE);
                if (StringUtilities.isEmpty(this.clientLanguage)) {
                    throw new Exception("Cannot read clientLanguage from file " + (String)setAidFilePath);
                }
                this.distributable = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_DISTRIBUTABLE);
                if (StringUtilities.isEmpty(this.distributable)) {
                    System.out.println("SetAidIni >> Distributable is empty, use default value 0");
                    this.distributable = DEFAULT_VALUE_DISTRIBUTABLE;
                }
                this.language = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_LANGUAGE);
                if (StringUtilities.isEmpty(this.language)) {
                    throw new Exception("Cannot read language from file " + (String)setAidFilePath);
                }
                this.displayName = this.file.getProperty(SECTION_LU_CONFIG, PROPERTITY_DISPLAYNAME);
                if (StringUtilities.isEmpty(this.displayName)) {
                    throw new Exception("Cannot read displayName from file " + (String)setAidFilePath);
                }
            } else {
                throw new Exception("Failed to load setAid.ini, file: " + (String)setAidFilePath);
            }
            System.out.println("SetAidIni >> SetAidIni loader: " + this.toString());
        }

        public void save(String filePath) throws Exception {
            if (this.file == null) {
                throw new Exception("setup.ini was not loaded sucessfully!");
            }
            IniSection section = this.file.getRoot().getSectionByName(SECTION_PREDEFINED_SMC_CONFIG);
            IniProperty property = section.getPropertyByName(PROPERTITY_PACKAGECHECKSUM);
            property.setValue(this.packageChecksum);
            System.out.println("SetAidIni >> Updated PackageChecksum, value: " + this.packageChecksum);
            property = section.getPropertyByName(PROPERTITY_APPTYPE);
            property.setValue(this.appType);
            System.out.println("SetAidIni >> Updated AppType, value: " + this.appType);
            property = section.getPropertyByName(PROPERTITY_PLATFORMTYPE);
            property.setValue(this.platformType);
            System.out.println("SetAidIni >> Updated PlatformType, value: " + this.platformType);
            section = this.file.getRoot().getSectionByName(SECTION_LU_CONFIG);
            property = section.getPropertyByName(PROPERTITY_SERVERMONIKER);
            property.setValue(this.serverMoniker);
            System.out.println("SetAidIni >> Updated ServerMoniker, value: " + this.serverMoniker);
            property = section.getPropertyByName(PROPERTITY_SERVERPRODUCT);
            property.setValue(this.serverProduct);
            System.out.println("SetAidIni >> Updated ServerProduct, value: " + this.serverProduct);
            property = section.getPropertyByName(PROPERTITY_SERVERVERSION);
            property.setValue(this.serverVersion);
            System.out.println("SetAidIni >> Updated ServerVersion, value: " + this.serverVersion);
            property = section.getPropertyByName(PROPERTITY_SERVERLANGUAGE);
            property.setValue(this.serverLanguage);
            System.out.println("SetAidIni >> Updated ServerLanguage, value: " + this.serverLanguage);
            property = section.getPropertyByName(PROPERTITY_CLIENTMONIKER);
            property.setValue(this.clientMoniker);
            System.out.println("SetAidIni >> Updated ClientMoniker, value: " + this.clientMoniker);
            property = section.getPropertyByName(PROPERTITY_CLIENTPRODUCT);
            property.setValue(this.clientProduct);
            System.out.println("SetAidIni >> Updated ClientProduct, value: " + this.clientProduct);
            property = section.getPropertyByName(PROPERTITY_CLIENTVERSION);
            property.setValue(this.clientVersion);
            System.out.println("SetAidIni >> Updated ClientVersion, value: " + this.clientVersion);
            property = section.getPropertyByName(PROPERTITY_CLIENTLANGUAGE);
            property.setValue(this.clientLanguage);
            System.out.println("SetAidIni >> Updated ClientLanguage, value: " + this.clientLanguage);
            property = section.getPropertyByName(PROPERTITY_DISTRIBUTABLE);
            if (property == null) {
                System.out.println("SetAidIni >> Adding Distributable, value: " + this.distributable);
                section.addProperty(PROPERTITY_DISTRIBUTABLE, this.distributable, false);
            } else {
                property.setValue(this.distributable);
            }
            System.out.println("SetAidIni >> Updated Distributable, value: " + this.distributable);
            property = section.getPropertyByName(PROPERTITY_DISPLAYNAME);
            property.setValue(this.displayName);
            System.out.println("SetAidIni >> Updated DisplayName, value: " + this.displayName);
            property = section.getPropertyByName(PROPERTITY_LANGUAGE);
            property.setValue(this.language);
            System.out.println("SetAidIni >> Updated Language, value: " + this.language);
            this.file.save(filePath);
            if (Files.notExists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                throw new Exception("Failed to save the file to " + filePath);
            }
            System.out.println("SetAidIni >> Sucessfully save to file " + filePath + ", data: " + this.toString());
        }

        public String toString() {
            return "SetAid.ini >> appType: " + this.appType + ", platformType: " + this.platformType + ", serverMoniker: " + this.serverMoniker + ", clientMoniker: " + this.clientMoniker + ", serverVersion: " + this.serverVersion + ", displayName: " + this.displayName;
        }

        public String getAppType() {
            return this.appType;
        }

        public String getPlatformType() {
            return this.platformType;
        }

        public String getServerMoniker() {
            return this.serverMoniker;
        }

        public String getClientMoniker() {
            return this.clientMoniker;
        }

        public String getServerVersion() {
            return this.serverVersion;
        }

        public String getPackageChecksum() {
            return this.packageChecksum;
        }

        public void setAppType(String appType) {
            this.appType = appType;
        }

        public void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        public void setServerMoniker(String serverMoniker) {
            this.serverMoniker = serverMoniker;
        }

        public void setClientMoniker(String clientMoniker) {
            this.clientMoniker = clientMoniker;
        }

        public void setServerVersion(String serverVersion) {
            this.serverVersion = serverVersion;
        }

        public void setPackageChecksum(String packageChecksum) {
            this.packageChecksum = packageChecksum;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getServerProduct() {
            return this.serverProduct;
        }

        public void setServerProduct(String serverProduct) {
            this.serverProduct = serverProduct;
        }

        public String getServerLanguage() {
            return this.serverLanguage;
        }

        public void setServerLanguage(String serverLanguage) {
            this.serverLanguage = serverLanguage;
        }

        public String getClientProduct() {
            return this.clientProduct;
        }

        public void setClientProduct(String clientProduct) {
            this.clientProduct = clientProduct;
        }

        public String getClientVersion() {
            return this.clientVersion;
        }

        public void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public String getClientLanguage() {
            return this.clientLanguage;
        }

        public void setClientLanguage(String clientLanguage) {
            this.clientLanguage = clientLanguage;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getDistributable() {
            return this.distributable;
        }

        public boolean isDistributable() {
            return DISTRIBUTABLE_TRUE.equals(this.distributable);
        }

        public void setDistributable(String distributable) {
            this.distributable = distributable;
        }
    }

    public static class SetupIni {
        private static final String SECTION_STARTUP = "Startup";
        private static final String PROPERTITY_PRODUCTVERSION = "ProductVersion";
        private static final String PROPERTITY_PACKAGECODE = "PackageCode";
        private static final String PROPERTITY_PRODUCTCODE = "ProductCode";
        String productVersion;
        String productCode;
        String packageCode;
        IniFile file = new IniFile();

        public SetupIni(String setupFilePath) throws Exception {
            boolean readResult;
            try (ZipFile zipFile = new ZipFile((String)setupFilePath);){
                System.out.println("SetupIni >> It's a zip file, " + zipFile.getName());
                readResult = this.file.read((String)setupFilePath, "setup.ini", null);
            }
            catch (IOException e) {
                if (Files.isDirectory(Paths.get((String)setupFilePath, new String[0]), new LinkOption[0])) {
                    setupFilePath = (String)setupFilePath + File.separator + "setup.ini";
                }
                readResult = this.file.read((String)setupFilePath);
            }
            if (readResult) {
                this.productVersion = this.file.getProperty(SECTION_STARTUP, PROPERTITY_PRODUCTVERSION);
                if (StringUtilities.isEmpty(this.productVersion)) {
                    throw new Exception("Cannot read productVersion from file " + (String)setupFilePath);
                }
                this.productCode = this.file.getProperty(SECTION_STARTUP, PROPERTITY_PRODUCTCODE);
                if (StringUtilities.isEmpty(this.productCode)) {
                    throw new Exception("Cannot read productCode from file " + (String)setupFilePath);
                }
                this.packageCode = this.file.getProperty(SECTION_STARTUP, PROPERTITY_PACKAGECODE);
                if (StringUtilities.isEmpty(this.packageCode)) {
                    throw new Exception("Cannot read packageCode from file " + (String)setupFilePath);
                }
            } else {
                throw new Exception("Failed to load setup.ini, file: " + (String)setupFilePath);
            }
            System.out.println("SetupIni >> SetupIni loader: " + this.toString());
        }

        public String toString() {
            return "SetAid.ini >> productVersion: " + this.productVersion + ", packageCode: " + this.packageCode + ", productCode: " + this.productCode;
        }

        public void save(String filePath) throws Exception {
            if (this.file == null) {
                throw new Exception(new Exception("setup.ini was not loaded sucessfully!"));
            }
            IniSection sectionLuConfig = this.file.getRoot().getSectionByName(SECTION_STARTUP);
            IniProperty property = sectionLuConfig.getPropertyByName(PROPERTITY_PRODUCTVERSION);
            property.setValue(this.productVersion);
            System.out.println("SetupIni >> Updated ProductVersion, value: " + this.productVersion);
            property = sectionLuConfig.getPropertyByName(PROPERTITY_PRODUCTCODE);
            property.setValue(this.productCode);
            System.out.println("SetupIni >> Updated ProductCode, value: " + this.productCode);
            property = sectionLuConfig.getPropertyByName(PROPERTITY_PACKAGECODE);
            property.setValue(this.packageCode);
            System.out.println("SetupIni >> Updated PackageCode, value: " + this.packageCode);
            this.file.save(filePath);
            if (Files.notExists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                throw new Exception("Failed to save the file to " + filePath);
            }
            System.out.println("SetupIni >> Sucessfully save the file to " + filePath + ", data: " + this.toString());
        }

        public String getProductVersion() {
            return this.productVersion;
        }

        public void setProductVersion(String productVersion) {
            this.productVersion = productVersion;
        }

        public String getProductCode() {
            return this.productCode;
        }

        public void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public String getPackageCode() {
            return this.packageCode;
        }

        public void setPackageCode(String packageCode) {
            this.packageCode = packageCode;
        }
    }
}

