/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.DatatypeConverter;

public class CertificateUtil {
    private static final Logger logger = Logger.getLogger(CertificateUtil.class.getName());
    static final String NEW_LINE = "\n";
    static final String CARRIAGE_RETURN = "\r";
    static final String CERTIFICATE_BEGIN = "-----BEGIN CERTIFICATE-----";
    static final String CERTIFICATE_END = "-----END CERTIFICATE-----";
    public static final String CLIENT_CERT_ENHANCED_KEY_USAGE = "1.3.6.1.5.5.7.3.2";

    public static Set<X509Certificate> getX509certsFromFile(String certFilePath) throws IOException, CertificateException {
        HashSet<X509Certificate> certificates = new HashSet<X509Certificate>();
        byte[] array = Files.readAllBytes(new File(certFilePath).toPath());
        Object var3_3 = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(array);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = cf.generateCertificates(is);
            for (X509Certificate x509Certificate : collection) {
                certificates.add(x509Certificate);
            }
        }
        return certificates;
    }

    public static String x509CertToPem(X509Certificate cert) throws CertificateEncodingException {
        String certStr = CertificateUtil.getBase64Binary(cert);
        StringWriter sw = new StringWriter();
        sw.write(CERTIFICATE_BEGIN);
        sw.write("\r\n");
        String[] lines = certStr.split(NEW_LINE);
        if (Arrays.stream(lines).anyMatch(StringUtilities::isEmpty)) {
            logger.log(Level.INFO, "Found empty lines from Base64Binary of certificate: {0}, SerialNumber: {1}", List.of(cert.getSubjectDN(), cert.getSerialNumber()).toArray());
        }
        Arrays.stream(lines).filter(line -> !StringUtilities.isEmpty(line)).forEach(line -> sw.write(line.replace(CARRIAGE_RETURN, "") + "\r\n"));
        sw.write(CERTIFICATE_END);
        sw.write("\r\n");
        return sw.toString();
    }

    static String getBase64Binary(X509Certificate cert) throws CertificateEncodingException {
        return DatatypeConverter.printBase64Binary((byte[])cert.getEncoded()).replaceAll("(.{64})", "$1\n");
    }

    public static String getIssuerAndSubject(X509Certificate certificate) {
        String issuerAndSubject = null;
        try {
            if (certificate == null) {
                logger.log(Level.INFO, "CertificateUtil> getIssuerAndSubject>> Certificate is null. Not able to get  issuer and subject.");
            } else {
                certificate.checkValidity();
                issuerAndSubject = certificate.getIssuerDN().toString().trim() + ";" + certificate.getSubjectDN().toString().trim();
            }
        }
        catch (CertificateException e1) {
            logger.log(Level.SEVERE, "CertificateUtil> getIssuerAndSubject>> Not able to get issuer and subject. Exception: {0}", e1.getMessage());
            LoggerUtilities.logException(e1);
        }
        return issuerAndSubject;
    }

    public static X509Certificate getCertificateFromFilePath(String certFilePath) {
        X509Certificate certificate;
        block8: {
            certificate = null;
            try {
                if (StringUtilities.isEmpty(certFilePath)) {
                    logger.log(Level.INFO, "CertificateUtil> getCertificateFromFilePath>> Certificate file path does not exist.");
                    break block8;
                }
                byte[] array = Files.readAllBytes(new File(certFilePath).toPath());
                try (ByteArrayInputStream is = new ByteArrayInputStream(array);){
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    certificate = (X509Certificate)cf.generateCertificate(is);
                }
            }
            catch (IOException | CertificateException e1) {
                logger.log(Level.SEVERE, "CertificateUtil> getCertificateFromFilePath>> Not able to fetch certificate. Exception: {0}", e1.getMessage());
                LoggerUtilities.logException(e1);
            }
        }
        return certificate;
    }

    public static boolean isClientAuthenticationCert(X509Certificate cert) {
        try {
            logger.log(Level.INFO, "CertificateUtil >> isClientAuthenticationCert >> SerialNumber: {0}, IssuerDN: {1}, SubjectDN: {2}, ExtendedKeyUsage: {3}", new Object[]{cert.getSerialNumber(), cert.getIssuerDN(), cert.getSubjectDN(), cert.getExtendedKeyUsage()});
            return Optional.ofNullable(cert.getExtendedKeyUsage()).orElse(List.of()).stream().anyMatch(keyUsage -> keyUsage.contains(CLIENT_CERT_ENHANCED_KEY_USAGE));
        }
        catch (CertificateParsingException e) {
            logger.log(Level.WARNING, "CertificateUtil >> isClientAuthenticationCert error: {0}", e.getMessage());
            return false;
        }
    }

    public static String getCNofSubjectDN(X509Certificate cert) {
        try {
            return new LdapName(cert.getSubjectX500Principal().getName()).getRdns().stream().filter(i -> i.getType().equalsIgnoreCase("CN")).findFirst().orElse(new Rdn("")).getValue().toString();
        }
        catch (RuntimeException | InvalidNameException e) {
            logger.log(Level.WARNING, "getCNofSubjectDN >> exception: {0}", e.getMessage());
            return cert.getSubjectDN().toString();
        }
    }
}

