/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.util.ErrorMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BundledGroupNamesObject {
    private String globalGroupName;
    private String[] temporaryGroupNames;
    private String defaultGroupName;
    private static BundledGroupNamesObject inst = null;

    public static synchronized BundledGroupNamesObject getInstance(SemClientGroupTree scgt) {
        if (inst == null) {
            inst = new BundledGroupNamesObject(scgt);
        }
        return inst;
    }

    public static synchronized void clear() {
        inst = null;
    }

    public String getGlobalGroupName() {
        return this.globalGroupName;
    }

    public String[] getTemporaryGroupNames() {
        if (this.temporaryGroupNames != null) {
            return Arrays.copyOf(this.temporaryGroupNames, this.temporaryGroupNames.length);
        }
        return null;
    }

    public String getDefaultGroupName() {
        return this.defaultGroupName;
    }

    private BundledGroupNamesObject(SemClientGroupTree scgt) {
        this.initialize(scgt);
        ErrorMsg.updateGlobalTempProperties(this.globalGroupName, this.temporaryGroupNames, this.defaultGroupName);
    }

    private List<SemClientGroup> getTemporaryGroups(SemClientGroupTree scgt) {
        ArrayList<SemClientGroup> tempGrpList = new ArrayList<SemClientGroup>(2);
        for (SemClientGroup semClientGroup : scgt.getSemClientGroup().getSemClientGroup()) {
            Integer type = semClientGroup.getOptType();
            if (type == null || type.intValue() != SemClientGroup.TEMPORARY.intValue()) continue;
            tempGrpList.add(semClientGroup);
        }
        return tempGrpList;
    }

    private void initialize(SemClientGroupTree scgt) {
        SemClientGroup global = scgt.getSemClientGroup();
        this.globalGroupName = global.getName();
        List<SemClientGroup> tempGrpList = this.getTemporaryGroups(scgt);
        if (tempGrpList.size() == 0) {
            return;
        }
        SemClientGroup firstTempGroup = tempGrpList.get(0);
        this.temporaryGroupNames = new String[tempGrpList.size()];
        int i = 0;
        for (SemClientGroup group : tempGrpList) {
            this.temporaryGroupNames[i++] = group.getName();
        }
        String defaultGrpId = scgt.getOptDefaultGroupId();
        if (defaultGrpId != null) {
            for (SemClientGroup semClientGroup : scgt.getSemClientGroup().getSemClientGroup()) {
                if (!semClientGroup.getId().equals(defaultGrpId)) continue;
                this.defaultGroupName = semClientGroup.getName();
                break;
            }
        }
        if (this.defaultGroupName == null) {
            this.defaultGroupName = firstTempGroup.getName();
        }
    }
}

