/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class AuditLogPolicyFilter {
    private static final String SAFE_POLICY_XSLT = "com/sygate/scm/util/template/policy_filter_for_audit_log.xsl";
    private static AuditLogPolicyFilter singleton = null;
    static final String XPATH_EXPR_OP_LIMIT = "1000";
    private final InputStream xsltInputStream = AuditLogPolicyFilter.class.getClassLoader().getResourceAsStream("com/sygate/scm/util/template/policy_filter_for_audit_log.xsl");
    private final Transformer transformer;

    public static synchronized AuditLogPolicyFilter get() throws TransformerConfigurationException {
        if (singleton == null) {
            singleton = new AuditLogPolicyFilter();
        }
        return singleton;
    }

    public AuditLogPolicyFilter() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("jdk.xml.xpathExprOpLimit", XPATH_EXPR_OP_LIMIT);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        this.transformer = factory.newTransformer(new StreamSource(this.xsltInputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long safeTransform(InputStream in, OutputStream out) {
        long size = 0L;
        try {
            StreamSource srcXML = new StreamSource(in);
            StreamResult transformedXML = new StreamResult(out);
            Transformer transformer = this.transformer;
            synchronized (transformer) {
                this.transformer.transform(srcXML, transformedXML);
            }
        }
        catch (TransformerConfigurationException ex) {
            System.out.println(String.format("ERROR: safeTransform configuration exception: %s", ex.getMessage()));
        }
        catch (TransformerException ex) {
            System.out.println(String.format("ERROR: safeTransform tranform exception: %s", ex.getMessage()));
        }
        catch (Exception ex) {
            System.out.println(String.format("ERROR: safeTransform exception: %s", ex.getMessage()));
        }
        return size;
    }

    public AuditLogPolicyFilter setXmlIndentOn(boolean value) {
        if (value) {
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.transformer.setOutputProperty("indent", "yes");
        } else {
            this.transformer.setOutputProperty("indent", "no");
        }
        return this;
    }
}

