/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.acl.AdminPrivilege;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.AllowedClientGroup;
import com.sygate.scm.common.configobject.schema.GroupId;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.common.valueobject.LoginUserVO;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AdminUtils {
    public static boolean isSysAdmin(SemAdministrator admin) {
        if (admin == null) {
            return false;
        }
        AdminUtils.checkAdminState(admin);
        return admin.getParent() instanceof SysAdministratorArray;
    }

    public static boolean isDomainAdmin(SemAdministrator admin) {
        if (admin == null) {
            return false;
        }
        AdminUtils.checkAdminState(admin);
        if (AdminUtils.isSysAdmin(admin)) {
            return false;
        }
        if (!(admin.getParent() instanceof AdminContext)) {
            return false;
        }
        return AdminPrivilege.isDomainAdminPrivilege(((AdminContext)admin.getParent()).getSemAdminPrivilege());
    }

    public static boolean isLimitedAdmin(SemAdministrator admin) {
        if (admin == null) {
            return false;
        }
        return !AdminUtils.isSysAdmin(admin) && !AdminUtils.isDomainAdmin(admin);
    }

    static void checkAdminState(SemAdministrator admin) {
        if (admin != null && !(admin.getParent() instanceof SysAdministratorArray) && !(admin.getParent() instanceof AdminContext)) {
            throw new IllegalStateException("The SemAdministrator's parent is incosistant!");
        }
    }

    public static void updateClientGroupACLIfNeed(AdminContext context, String rootGroupId) {
        if (context == null) {
            return;
        }
        if (AdminPrivilege.isDomainAdminPrivilege(context.getSemAdminPrivilege())) {
            return;
        }
        AdminUtils.updateClientGroupACLIfNeed(context.getSemAdminPrivilege(), rootGroupId);
    }

    public static void updateClientGroupACLIfNeed(SemAdminPrivilege privilege, String rootGroupId) {
        if (privilege == null || StringUtilities.isEmpty(rootGroupId)) {
            return;
        }
        if (AdminUtils.isAllowedGroupEmpty(privilege) && AdminUtils.isDisallowedGroupEmpty(privilege) && AdminUtils.isReadonlyGroupEmpty(privilege)) {
            AdminUtils.deleteInvalidChildren(privilege.getAllowedClientGroup());
            GroupId groupId = new GroupId();
            groupId.setOptContent(rootGroupId);
            privilege.getAllowedClientGroup().addGroupId(groupId);
        }
    }

    private static void deleteInvalidChildren(AllowedClientGroup allowedClientGroup) {
        if (allowedClientGroup != null) {
            for (GroupId g : allowedClientGroup.getGroupId()) {
                if (g == null) continue;
                allowedClientGroup.removeGroupId(g);
            }
        }
    }

    private static boolean isAllowedGroupEmpty(SemAdminPrivilege privilege) {
        if (privilege == null || privilege.getAllowedClientGroup() == null) {
            return true;
        }
        boolean result = true;
        for (GroupId g : privilege.getAllowedClientGroup().getGroupId()) {
            if (StringUtilities.isEmpty(g.getOptContent())) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean isReadonlyGroupEmpty(SemAdminPrivilege privilege) {
        if (privilege == null || privilege.getOptReadOnlyClientGroup() == null) {
            return true;
        }
        boolean result = true;
        for (GroupId g : privilege.getOptReadOnlyClientGroup().getGroupId()) {
            if (StringUtilities.isEmpty(g.getOptContent())) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean isDisallowedGroupEmpty(SemAdminPrivilege privilege) {
        if (privilege == null || privilege.getOptDisallowedClientGroup() == null) {
            return true;
        }
        boolean result = true;
        for (GroupId g : privilege.getOptDisallowedClientGroup().getGroupId()) {
            if (StringUtilities.isEmpty(g.getOptContent())) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String getUserName(LoginUserVO loginUser) {
        String userName = loginUser.getUserName();
        if (StringUtilities.isEmpty(userName) || userName.equalsIgnoreCase("DBA")) {
            System.out.println("AdminUtils > getUserName>> Login user-name is null or empty or 'DBA', setting to default user-name.");
            userName = AdminUtils.getDefaultUsername();
        }
        return userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultUsername() {
        InputStream saaIS = null;
        try {
            saaIS = TemplateManager.class.getResourceAsStream("SysAdministratorArray_template.xml");
            Template saaTmpl = TemplateManager.getTemplate(saaIS);
            SysAdministratorArray sysAdminArray = (SysAdministratorArray)AbstractSchema.readXML(saaTmpl.getXML());
            SemAdministrator sysAdmin = sysAdminArray.getSemAdministrator(0);
            String string = sysAdmin.getName();
            return string;
        }
        catch (SAXException e) {
            LoggerUtilities.logException(e);
        }
        catch (ParserConfigurationException e) {
            LoggerUtilities.logException(e);
        }
        catch (IOException e) {
            LoggerUtilities.logException(e);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException(e);
        }
        finally {
            IOUtilities.closeInputStream(saaIS);
        }
        return "";
    }

    public static String getSysAdminEmailAddress(Connection dbConn, String type) {
        String adminEmailAddress = "";
        AbstractSchema schemaObject = AdminUtils.geSysAdminArray(dbConn, type);
        if (schemaObject == null) {
            System.out.println("AdminsUtils> getSysAdminEmailAddress>> SysAdministratorArray object retrieved from database is null.");
        } else {
            SysAdministratorArray sysAdministratorarray = (SysAdministratorArray)schemaObject;
            for (int i = 0; i < sysAdministratorarray.getSemAdministratorCount(); ++i) {
                String emailAddr;
                SemAdministrator sysAdmin = sysAdministratorarray.getSemAdministrator(i);
                if (sysAdmin == null || !"AF3C39A10A320801000000DBF200C60A".equals(sysAdmin.getId()) || StringUtilities.isEmpty(emailAddr = sysAdmin.getOptEmailAddress())) continue;
                adminEmailAddress = emailAddr;
                break;
            }
        }
        return adminEmailAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractSchema geSysAdminArray(Connection dbConn, String type) {
        long startTime = System.currentTimeMillis();
        AbstractSchema schemaObject = null;
        String SYS_ADMINISTRATOR_ARRAY_SQL = "SELECT CONTENT FROM BASIC_METADATA WHERE ID = ? AND TYPE = ?";
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        InputStream inputStream = null;
        try {
            statement = dbConn.prepareStatement(SYS_ADMINISTRATOR_ARRAY_SQL);
            statement.setString(1, "3396C0130AC860A001FABA46BDDD21E2");
            statement.setString(2, type);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                inputStream = resultSet.getBinaryStream(1);
                schemaObject = AbstractSchema.readXML(inputStream);
            }
        }
        catch (Throwable t) {
            System.out.println("AdminUtils> getAbstractSchemaObject>> Error while trying to retrieve TopLevelObject from database. Exception message: " + t.getMessage());
            LoggerUtilities.logException(t);
        }
        finally {
            IOUtilities.closeInputStream(inputStream);
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LoggerUtilities.logException(e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LoggerUtilities.logException(e);
                }
            }
            System.out.println("AdminUtils > getAbstractSchemaObject>> Time taken to get value from DB: " + (System.currentTimeMillis() - startTime) + " milli seconds.");
        }
        return schemaObject;
    }
}

