/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.util;

import com.sygate.scm.common.configobject.SchemaHelper;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.common.util.AdminLegacyMatcher;
import java.util.ArrayList;
import java.util.List;

public class AdminMatcher {
    private static AdminMatcher singleton = new AdminMatcher();
    private static AdminMatcher legacySingleton = new AdminLegacyMatcher();

    public static AdminMatcher getInstance() {
        return singleton;
    }

    public static AdminMatcher getLegacyInstance() {
        return legacySingleton;
    }

    protected AdminMatcher() {
    }

    public SemAdministrator match(SysAdministratorArray rootAdminArray, String adminName) {
        return SchemaHelper.getSystemAdmin(rootAdminArray, adminName);
    }

    public SemAdministrator match(List<AdminContext> adminContexts, String adminName) {
        return SchemaHelper.getDomainLimitedAdmin(adminContexts, adminName);
    }

    public SemAdministrator match(String adminName, List<SemAdministrator> admins) {
        if (adminName != null && admins != null) {
            for (SemAdministrator admin : admins) {
                if (admin == null || !admin.getName().equalsIgnoreCase(adminName)) continue;
                return admin;
            }
        }
        return null;
    }

    private List<SemAdministrator> matchAsList(SysAdministratorArray rootAdminArray, String adminName) {
        return SchemaHelper.getAllSysAdmin(rootAdminArray, adminName);
    }

    private List<SemAdministrator> matchAsList(String adminName, List<SemAdministrator> admins) {
        ArrayList<SemAdministrator> result = new ArrayList<SemAdministrator>();
        if (adminName != null && admins != null) {
            for (SemAdministrator admin : admins) {
                if (admin == null || !admin.getName().equalsIgnoreCase(adminName)) continue;
                result.add(admin);
            }
        }
        return result;
    }

    public List<SemAdministrator> matchAsList(SysAdministratorArray rootAdminArray, List<SemAdministrator> domainLimitedAdmin, String adminName) {
        ArrayList<SemAdministrator> result = new ArrayList<SemAdministrator>();
        result.addAll(this.matchAsList(adminName, domainLimitedAdmin));
        result.addAll(this.matchAsList(rootAdminArray, adminName));
        return result;
    }
}

