/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.util.StringUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class UiUtilities {
    private static GridBagConstraints gridBagConstraints;

    public static void centerComponent(Component dlg) {
        GraphicsConfiguration graphicsConfiguration = dlg.getGraphicsConfiguration();
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Dimension screenSize = screenBounds.getSize();
        Dimension dlgSize = dlg.getSize();
        Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        int availableScreenHeight = screenSize.height - scnMax.bottom - scnMax.top;
        int availableScreenWidth = screenSize.width - scnMax.left - scnMax.right;
        if (dlgSize.height > availableScreenHeight) {
            dlgSize.height = availableScreenHeight;
        }
        if (dlgSize.width > availableScreenWidth) {
            dlgSize.width = availableScreenWidth;
        }
        dlg.setLocation(screenBounds.x + scnMax.left + (availableScreenWidth - dlgSize.width) / 2, screenBounds.y + scnMax.top + (availableScreenHeight - dlgSize.height) / 2);
    }

    public static void centerComponent(Component dlg, Container parent) {
        Dimension screenSize = parent.getSize();
        Dimension dlgSize = dlg.getSize();
        Point parentLoc = parent.getLocation();
        if (dlgSize.height > screenSize.height) {
            dlgSize.height = screenSize.height;
        }
        if (dlgSize.width > screenSize.width) {
            dlgSize.width = screenSize.width;
        }
        dlg.setLocation((screenSize.width - dlgSize.width) / 2 + parentLoc.x, (screenSize.height - dlgSize.height) / 2 + parentLoc.y);
    }

    public static void centerComponentInMultiGraphicsDevice(Component dlg, Container parent) {
        Rectangle screenRect = UiUtilities.getFreeScreenBouds(parent);
        Dimension screenSize = parent.getSize();
        Dimension dlgSize = dlg.getSize();
        Point parentLoc = parent.getLocation();
        int locX = (screenSize.width - dlgSize.width) / 2 + parentLoc.x;
        int locY = (screenSize.height - dlgSize.height) / 2 + parentLoc.y;
        int locRight = screenRect.x + screenRect.width - dlgSize.width;
        int locBottom = screenRect.y + screenRect.height - dlgSize.height;
        locX = locX < screenRect.x ? screenRect.x : locX;
        locY = locY < screenRect.y ? screenRect.y : locY;
        locX = locX > locRight ? locRight : locX;
        int n = locY = locY > locBottom ? locBottom : locY;
        if (locX != screenRect.x || locY != screenRect.y) {
            dlg.setLocation(locX, locY);
        } else {
            UiUtilities.centerComponent(dlg);
        }
    }

    public static Image loadImage(Class<?> resLoader, String fileName) {
        if (StringUtilities.isEmpty(fileName)) {
            return null;
        }
        Image m_image = null;
        m_image = resLoader == null ? Toolkit.getDefaultToolkit().getImage(fileName) : Toolkit.getDefaultToolkit().getImage(UiUtilities.getResource(resLoader, fileName));
        return m_image;
    }

    public static URL getResource(Class<?> resLoader, String fileName) {
        if (StringUtilities.isEmpty(fileName) || resLoader == null) {
            return null;
        }
        return resLoader.getResource(fileName);
    }

    public static Rectangle getFreeScreenBouds(Component parent) {
        Rectangle screenRect = parent.getGraphicsConfiguration().getBounds();
        Insets scrInsets = Toolkit.getDefaultToolkit().getScreenInsets(parent.getGraphicsConfiguration());
        screenRect.height -= scrInsets.bottom;
        screenRect.width -= scrInsets.right;
        screenRect.x += scrInsets.left;
        screenRect.y += scrInsets.top;
        return screenRect;
    }

    public static Dimension getMaxScreenDimension(Component parent) {
        Rectangle screenRect = parent.getGraphicsConfiguration().getBounds();
        Insets scrInsets = Toolkit.getDefaultToolkit().getScreenInsets(parent.getGraphicsConfiguration());
        screenRect.height -= scrInsets.bottom;
        screenRect.width -= scrInsets.right;
        screenRect.height -= scrInsets.top;
        screenRect.width -= scrInsets.left;
        Dimension size = new Dimension(screenRect.width, screenRect.height);
        return size;
    }

    public static GridBagConstraints getGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, int insetsTop, int insetsLeft, int insetsBottom, int insetsRight, int ipadx, int ipady) {
        if (gridBagConstraints == null) {
            gridBagConstraints = new GridBagConstraints();
        }
        UiUtilities.gridBagConstraints.gridx = gridx;
        UiUtilities.gridBagConstraints.gridy = gridy;
        UiUtilities.gridBagConstraints.gridwidth = gridwidth;
        UiUtilities.gridBagConstraints.gridheight = gridheight;
        UiUtilities.gridBagConstraints.weightx = weightx;
        UiUtilities.gridBagConstraints.weighty = weighty;
        UiUtilities.gridBagConstraints.anchor = anchor;
        UiUtilities.gridBagConstraints.fill = fill;
        UiUtilities.gridBagConstraints.insets.set(insetsTop, insetsLeft, insetsBottom, insetsRight);
        UiUtilities.gridBagConstraints.ipadx = ipadx;
        UiUtilities.gridBagConstraints.ipady = ipady;
        return gridBagConstraints;
    }

    public static void setDefaultButton(RootPaneContainer rootPaneContainer, JButton button) {
        rootPaneContainer.getRootPane().setDefaultButton(button);
    }

    public static void setupScrollPane(JScrollPane jScrollPane, JTextPane jTextPane) {
        UiUtilities.setupScrollPane(jScrollPane, jTextPane, CustomLookAndFeel.DEFAULT_BORDER);
    }

    public static void setupScrollPane(JScrollPane jScrollPane, JTextArea jTextArea) {
        UiUtilities.setupScrollPane(jScrollPane, jTextArea, CustomLookAndFeel.TEXT_AREA_BORDER);
    }

    public static void setupScrollPane(JScrollPane jScrollPane, JPanel jPanel) {
        UiUtilities.setupScrollPane(jScrollPane, jPanel, CustomLookAndFeel.SIMPLE_BORDER);
    }

    public static void setupScrollPane(JScrollPane jScrollPane, JList<?> jList) {
        UiUtilities.setupScrollPane(jScrollPane, jList, CustomLookAndFeel.SIMPLE_BORDER);
    }

    public static void setupScrollPane(JScrollPane jScrollPane, JTable jTable) {
        jScrollPane.setViewportView(jTable);
    }

    public static void setupScrollPane(JScrollPane jScrollPane, JTree jTree) {
        UiUtilities.setupScrollPane(jScrollPane, jTree, CustomLookAndFeel.SIMPLE_BORDER);
    }

    public static JComponent setupAlignedLabel(JLabel label, JTextComponent text) {
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
        panel.add(label);
        Insets insets = text.getInsets();
        if (null != insets) {
            Border border = BorderFactory.createEmptyBorder(insets.top, 0, insets.bottom, 0);
            panel.setBorder(border);
        }
        return panel;
    }

    public static JComponent setupAlignedLabel(JLabel label, JScrollPane scrollPane) {
        Component scrollPaneView;
        Insets insetsScrollPane;
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
        panel.add(label);
        int top = 0;
        int bottom = 0;
        Border borderScrollPane = scrollPane.getBorder();
        if (null != borderScrollPane && null != (insetsScrollPane = borderScrollPane.getBorderInsets(scrollPane))) {
            top += insetsScrollPane.top;
            bottom += insetsScrollPane.bottom;
        }
        if (null != scrollPane.getViewport() && null != (scrollPaneView = scrollPane.getViewport().getView())) {
            Insets textInsets;
            Insets insetsScrollPaneViewport;
            Border borderScrollPaneViewport = scrollPane.getViewportBorder();
            if (null != borderScrollPaneViewport && null != (insetsScrollPaneViewport = borderScrollPaneViewport.getBorderInsets(scrollPaneView))) {
                top += insetsScrollPaneViewport.top;
                bottom += insetsScrollPaneViewport.bottom;
            }
            if (scrollPaneView instanceof JTextComponent && null != (textInsets = ((JTextComponent)scrollPaneView).getInsets())) {
                top += textInsets.top;
                bottom += textInsets.bottom;
            }
        }
        Border border = BorderFactory.createEmptyBorder(top, 0, bottom, 0);
        panel.setBorder(border);
        return panel;
    }

    public static void setEditorPaneHonorUIDefaults(JEditorPane jEditorPane, Boolean value) {
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", value);
    }

    private static void setupScrollPane(JScrollPane jScrollPane, JComponent jComponent, Border border) {
        jScrollPane.setViewportView(jComponent);
        jScrollPane.setViewportBorder(border);
    }

    public static void setupTitledPanel(JPanel jPanel, String title) {
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), CustomLookAndFeel.TITLED_PANEL_EMPTY_BORDER));
    }
}

