/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Font;
import javax.swing.JComponent;

public class UIFontUtilities {
    private static final MessageResourcesFile UI_RES = new MessageResourcesFile("com.sygate.scm.common.ui.ui");
    public static final String STANDARD_FONT_NAME = UIFontUtilities.getStandFontName();
    private static final int STANDARD_FONT_SIZE = UIFontUtilities.getStandFontSize();
    private static final int HEADING_FONT_SIZE = STANDARD_FONT_SIZE + 5;
    private static final int LOCKUP_FONT_SIZE = HEADING_FONT_SIZE + 2;
    static final int LOADING_SCREEN_FONT_SIZE = UIFontUtilities.getLoadingScreenFontSize();
    public static final int QUICKSTART_FONT_SIZE1 = UIFontUtilities.getQuickStartFontSize1();
    private static final String UNITS = "pt";
    public static final String STANDARD_FONT_SIZE_WITH_UNITS = STANDARD_FONT_SIZE + "pt";
    public static final String HEADING_FONT_SIZE_WITH_UNITS = HEADING_FONT_SIZE + "pt";
    private static final String LOCKUP_FONT_SIZE_WITH_UNITS = LOCKUP_FONT_SIZE + "pt";
    public static final Font STANDARD_FONT = new Font(STANDARD_FONT_NAME, 0, STANDARD_FONT_SIZE);
    public static final Font BOLD_FONT = STANDARD_FONT.deriveFont(1);
    public static final Font ITALIC_FONT = STANDARD_FONT.deriveFont(2);
    public static final Font CONTENT_PANE_HEADING = new Font(STANDARD_FONT_NAME, 0, STANDARD_FONT_SIZE + 10);
    public static final Font HEADING_FONT = new Font(STANDARD_FONT_NAME, 1, HEADING_FONT_SIZE);
    public static final Font TITLE_FONT = new Font(STANDARD_FONT_NAME, 1, STANDARD_FONT_SIZE + 3);
    public static final Font SUBTITLE_FONT = new Font(STANDARD_FONT_NAME, 1, STANDARD_FONT_SIZE + 1);
    public static final Font QUICK_START_LINK_FONT = new Font(STANDARD_FONT_NAME, 0, STANDARD_FONT_SIZE + 2);
    public static final String HTML_CSS = "<HEAD><style type=\"text/css\"> BODY { font-family: " + STANDARD_FONT_NAME + "; font-size: " + STANDARD_FONT_SIZE_WITH_UNITS + "; }</style></HEAD>";
    @Deprecated
    public static final int AWS_FONT_SIZE_32 = 32;
    @Deprecated
    public static final int AWS_FONT_SIZE_16 = 16;

    public static String formatLockupText(String text) {
        return "<div style='font-family:" + STANDARD_FONT_NAME + ";font-size:" + LOCKUP_FONT_SIZE_WITH_UNITS + ";color:" + UIColorUtilities.colorToString(UIColorUtilities.LOCKUP_FOREGROUND_COLOR) + ";font-weight:bold'>" + text + "</div>";
    }

    private static String getStandFontName() {
        String fontName = UI_RES.getString("CustomLookAndFeel.standFontName");
        if (fontName == null || fontName.equals("")) {
            fontName = "SansSerif";
        }
        return fontName;
    }

    private static int getStandFontSize() {
        String fontSize = UI_RES.getString("CustomLookAndFeel.standFontSize");
        int iFontSize = 11;
        if (fontSize != null && !fontSize.equals("")) {
            try {
                iFontSize = Integer.parseInt(fontSize);
            }
            catch (Exception e) {
                LoggerUtilities.logException(e);
            }
        }
        return iFontSize;
    }

    private static int getLoadingScreenFontSize() {
        int fontSize = 32;
        try {
            fontSize = Integer.parseInt(UI_RES.getString("LoadingScreen.fontSize"));
        }
        catch (NumberFormatException e) {
            LoggerUtilities.logException(e);
        }
        return fontSize;
    }

    private static int getQuickStartFontSize1() {
        int fontSize1 = 32;
        try {
            fontSize1 = Integer.parseInt(UI_RES.getString("QuickStartDialog.fontSize1"));
        }
        catch (NumberFormatException e) {
            LoggerUtilities.logException(e);
        }
        return fontSize1;
    }

    public static JComponent setBoldFont(JComponent component) {
        component.setFont(component.getFont().deriveFont(1));
        return component;
    }
}

