/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UIColorUtilities {
    public static final String BLUE_RGB_HEXCODE = "#0076a3";
    public static final Color ERROR_FOREGROUND = ColorPalette.RED;
    static final Color ERROR_BACKGROUND = ColorPalette.RED;
    static final Color FOCUS_BORDER = ColorPalette.GRAY;
    public static final Color CONTENT_PANE_BACKGROUND = ColorPalette.LIGHTEST_GRAY;
    public static final Color TABLE_STRIPE = ColorPalette.LIGHTEST_GRAY;
    public static final Color DEFAULT_BACKGROUND = ColorPalette.WHITE;
    public static final Color DEFAULT_SELECTION_BACKGROUND = ColorPalette.LIGHT_YELLOW;
    public static final Color DEFAULT_FOREGROUND = ColorPalette.SOFT_BLACK;
    public static final Color SOFT_FOREGROUND = ColorPalette.GRAY;
    public static final Color LINK_FOREGROUND = ColorPalette.BLUE;
    public static final Color LINK_HOVER_FOREGROUND = ColorPalette.LIGHT_BLUE;
    public static final Color ON_FOREGROUND_COLOR = ColorPalette.GREEN;
    static final Color SUCCESS_BACKGROUND = ColorPalette.GREEN;
    public static final Color WARNING_BACKGROUND = ColorPalette.YELLOW;
    public static final Color CONTROL_BACKGROUND = ColorPalette.LIGHT_GRAY;
    static final List<Object> CONTROL_GRADIENT;
    public static final Color CONTROL_DISABLED_FOREGROUND;
    public static final Color CONTROL_DISABLED_GRAYOUT_BACKGROUND;
    public static final Color SECONDARY_NAVIGATION_BACKGROUND;
    public static final Color SECONDARY_NAVIGATION_SELECTED_FOREGROUND;
    public static final Color SECONDARY_NAVIGATION_DISABLED_FOREGROUND;
    public static final Color SECONDARY_NAVIGATION_FOREGROUND;
    static final Color SECONDARY_NAVIGATION_ROLLOVER_FOREGROUND;
    public static final Color LOCKUP_BACKGROUND_COLOR;
    public static final Color LOCKUP_FOREGROUND_COLOR;
    public static final Color MAIN_NAVIGATION_BACKGROUND;
    public static final Color MAIN_NAVIGATION_FOREGROUND;
    static final Color MAIN_NAVIGATION_SELECTED_FOREGROUND;
    static final Color MAIN_NAVIGATION_SELECTED;
    static final Color MAIN_NAVIGATION_ROLLOVER;
    public static final Color DEFAULT_BUTTON_BACKGROUND;
    public static final Color BANNER_BACKGROUND;
    public static final Color ACCENT_BORDER;
    public static final Color LOGIN_PANE;
    public static final Color CELL_SELECTION_BACKGROUND;
    @Deprecated
    public static final Color LIGHT_LINE_COLOR;
    @Deprecated
    public static final String CRITICAL_LINE_COLOR = "a36262";
    @Deprecated
    public static final String NORMAL_LINE_COLOR = "7187ad";
    @Deprecated
    public static final String WARNING_LINE_COLOR = "d7ae0b";
    @Deprecated
    public static final Color WEEK_DAYS_FOREGROUND;
    @Deprecated
    public static final Color DAYS_FOREGROUND;
    @Deprecated
    public static final Color SELECTED_DAY_FOREGROUND;
    @Deprecated
    public static final Color SELECTED_DAY_BACKGROUND;
    @Deprecated
    public static final Color LATEST_COLOR;
    @Deprecated
    public static final Color OLD_COLOR;
    @Deprecated
    public static final Color FW_RULE_BLUE_LINE;
    @Deprecated
    public static final Color TABLE_EDITABLE_CELL_BG_COLOR;
    @Deprecated
    public static final Color TABLE_ERROR_CELL_SELECT_COLOR;
    @Deprecated
    public static final Color TABLE_ERROR_CELL_BG_COLOR;
    @Deprecated
    public static final Color DISABLED_BACKGROUND;
    @Deprecated
    public static final Color ENABLED_BACKGROUND_LIGHT;
    @Deprecated
    public static final Color TITLED_BORDER_HIGHLIGHT;
    @Deprecated
    public static final Color TITLED_BORDER_SHADOW;
    @Deprecated
    public static final Color TITLED_BORDER_SHADOW_OUTTER;

    private static String colorToStringWOHash(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    public static String colorToString(Color color) {
        return "#" + UIColorUtilities.colorToStringWOHash(color);
    }

    static {
        CONTROL_DISABLED_FOREGROUND = ColorPalette.LIGHTER_GRAY;
        CONTROL_DISABLED_GRAYOUT_BACKGROUND = ColorPalette.LIGHT_GRAY;
        SECONDARY_NAVIGATION_BACKGROUND = ColorPalette.GRAY;
        SECONDARY_NAVIGATION_SELECTED_FOREGROUND = ColorPalette.LIGHT_YELLOW;
        SECONDARY_NAVIGATION_DISABLED_FOREGROUND = ColorPalette.LIGHTER_GRAY;
        SECONDARY_NAVIGATION_FOREGROUND = ColorPalette.LIGHT_GRAY;
        SECONDARY_NAVIGATION_ROLLOVER_FOREGROUND = ColorPalette.WHITE;
        LOCKUP_BACKGROUND_COLOR = ColorPalette.YELLOW;
        LOCKUP_FOREGROUND_COLOR = ColorPalette.BLACK;
        MAIN_NAVIGATION_BACKGROUND = ColorPalette.DARK_GRAY;
        MAIN_NAVIGATION_FOREGROUND = ColorPalette.LIGHT_GRAY;
        MAIN_NAVIGATION_SELECTED_FOREGROUND = ColorPalette.DARK_GRAY;
        MAIN_NAVIGATION_SELECTED = ColorPalette.LIGHT_YELLOW;
        MAIN_NAVIGATION_ROLLOVER = ColorPalette.GRAY;
        DEFAULT_BUTTON_BACKGROUND = ColorPalette.YELLOW;
        BANNER_BACKGROUND = ColorPalette.YELLOW;
        ACCENT_BORDER = ColorPalette.BLACK;
        LOGIN_PANE = ColorPalette.DARK_GRAY;
        CELL_SELECTION_BACKGROUND = ColorPalette.YELLOW;
        ArrayList<Serializable> gradients = new ArrayList<Serializable>(5);
        gradients.add(Float.valueOf(0.28f));
        gradients.add(Float.valueOf(0.0f));
        gradients.add(CONTROL_BACKGROUND);
        gradients.add(CONTROL_BACKGROUND);
        gradients.add(CONTROL_BACKGROUND);
        CONTROL_GRADIENT = Collections.unmodifiableList(gradients);
        LIGHT_LINE_COLOR = Color.WHITE;
        WEEK_DAYS_FOREGROUND = Color.black;
        DAYS_FOREGROUND = Color.blue;
        SELECTED_DAY_FOREGROUND = Color.white;
        SELECTED_DAY_BACKGROUND = Color.blue;
        LATEST_COLOR = Color.GREEN.darker();
        OLD_COLOR = Color.RED.darker();
        FW_RULE_BLUE_LINE = new Color(200, 220, 255);
        TABLE_EDITABLE_CELL_BG_COLOR = new Color(255, 255, 255);
        TABLE_ERROR_CELL_SELECT_COLOR = new Color(255, 0, 0);
        TABLE_ERROR_CELL_BG_COLOR = new Color(255, 204, 255);
        DISABLED_BACKGROUND = new Color(241, 240, 227);
        ENABLED_BACKGROUND_LIGHT = new Color(247, 247, 247);
        TITLED_BORDER_HIGHLIGHT = Color.WHITE;
        TITLED_BORDER_SHADOW = new Color(148, 145, 140);
        TITLED_BORDER_SHADOW_OUTTER = new Color(103, 101, 98);
    }

    private static interface ColorPalette {
        public static final Color BLACK = Color.BLACK;
        public static final Color SOFT_BLACK = Color.decode("#333333");
        public static final Color WHITE = Color.WHITE;
        public static final Color LIGHT_YELLOW = Color.decode("#FFDB8F");
        public static final Color YELLOW = Color.decode("#FDBB30");
        public static final Color LIGHTEST_GRAY = Color.decode("#F2F2F2");
        public static final Color LIGHT_GRAY = Color.decode("#E1E1E1");
        public static final Color LIGHTER_GRAY = Color.decode("#AAAAAA");
        public static final Color GRAY = Color.decode("#636363");
        public static final Color DARK_GRAY = Color.decode("#333333");
        public static final Color GREEN = Color.decode("#74c476");
        public static final Color RED = Color.decode("#ff4900");
        public static final Color BLUE = Color.decode("#0076a3");
        public static final Color LIGHT_BLUE = Color.decode("#00aeef");
    }
}

