/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.ReadOnlyTextArea;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TelemetryOptionPanel
extends JPanel {
    private static final long serialVersionUID = -5432647536549020628L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.util.util");
    private static final String OPT_IN_TELEMETRY = MSG_RES.getString("TelemetryPanel.optInTelemetry");
    private static final String OPT_IN_TELEMETRY_DESC = MSG_RES.getString("TelemetryPanel.telemetryBenefitsDesc");
    private JCheckBox telemetryOptInBox = new JCheckBox();

    public TelemetryOptionPanel() {
        this.init();
    }

    private void init() {
        String privacyLink = null;
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage()};
        String privacyStatementLink = MSG_RES.getString("TelemetryPanel.privacyStatementLink");
        privacyLink = MessageFormat.format(privacyStatementLink, obj);
        System.out.println("Privacy link = " + privacyLink);
        this.telemetryOptInBox.setText(OPT_IN_TELEMETRY);
        this.telemetryOptInBox.setSelected(true);
        JPanel telemetryBox = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        telemetryBox.setLayout(gridbag);
        int gridy = 0;
        telemetryBox.add((Component)this.telemetryOptInBox, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JLabel desc = new JLabel(this.getHTMLString(OPT_IN_TELEMETRY_DESC));
        telemetryBox.add((Component)desc, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 0, 10), 0, 0));
        ReadOnlyTextArea telemetryEnabled = new ReadOnlyTextArea(this);
        telemetryEnabled.setText(MSG_RES.getString("TelemetryPanel.telemetryEnabled"));
        telemetryBox.add((Component)telemetryEnabled, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        JLabel moreLinkPane = this.getLinkPane(MSG_RES.getString("TelemetryPanel.telemetryMore"), URLUtility.getVersionLanguageErrorUpdatedUrl("com.sygate.scm.util.util", "TelemetryPanel.telemetryMoreURL", null));
        telemetryBox.add((Component)moreLinkPane, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 5, 10), 0, 0));
        JLabel privacyLinkPane = this.getLinkPane(MSG_RES.getString("TelemetryPanel.viewPrivacy"), privacyLink);
        telemetryBox.add((Component)privacyLinkPane, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 5, 10), 0, 0));
        telemetryBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)telemetryBox, "North");
    }

    public JCheckBox getTelemetryOptIncheckBox() {
        return this.telemetryOptInBox;
    }

    public boolean isTelemetryOptedIn() {
        return this.telemetryOptInBox.isSelected();
    }

    public void setTelemetryOptedIn(boolean optIn) {
        this.telemetryOptInBox.setSelected(optIn);
    }

    private JLabel getLinkPane(String displayText, final String kbUrl) {
        if (displayText == null || kbUrl == null) {
            throw new IllegalArgumentException();
        }
        HtmlEnabledJLabel pane = new HtmlEnabledJLabel(true);
        pane.setText(displayText);
        pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ex) {
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    ClientAgent.getCurrentInstance().openInNewTab(kbUrl);
                    return;
                }
                URLUtility.showURL(kbUrl);
            }
        });
        return pane;
    }

    private String getHTMLString(String desc) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><body>");
        buffer.append(desc);
        buffer.append("</body></html>");
        return buffer.toString();
    }
}

