/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.communicate.SmartCardPkcsKeyStore;
import com.sygate.scm.common.exception.SmartCardRuntimeError;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.util.Utility;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class SmartCardPinHandler
implements CallbackHandler {
    private static final Logger logger = Logger.getLogger(SmartCardPinHandler.class.getName());
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.common.ui.ui");
    public static final int SMARTCARD_PIN_USER_ACTION_ERROR = 0;
    public static final int SMARTCARD_PIN_USER_ACTION_SUCCESS = 1;
    public static final int SMARTCARD_PIN_USER_ACTION_CANCEL = -99;
    public static final String SMARTCARD_PIN_USER_ACTION_CANCELLATION_ERROR_MSG = "Enter smart card PIN operation was canceled by user";
    char[] password = new char[0];

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof PasswordCallback) {
                while (this.handlePasswordCallback((PasswordCallback)callbacks[i]) == 0) {
                }
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Callback not supported " + callbacks[i].getClass().getName());
        }
    }

    public char[] getPassword() {
        return this.password;
    }

    public void clearPassword() {
        Utility.clearPassword(this.password);
        this.password = new char[0];
    }

    int handlePasswordCallback(PasswordCallback passCb) {
        if (!SmartCardPkcsKeyStore.isSmartCardActive()) {
            logger.log(Level.SEVERE, "SmartCardPinHandler >> The smart card is not active now. If smart card is already logged out we should block any SSL by smart card!");
            throw new SmartCardRuntimeError("Smart Card runtime error, smart card is not active!");
        }
        if (this.password.length > 0) {
            logger.log(Level.INFO, "SmartCardPinHandler >> Using cached password.");
            passCb.setPassword(this.password);
            return 1;
        }
        if (SmartCardPkcsKeyStore.isAfterSmartCardLogin()) {
            logger.log(Level.SEVERE, "SmartCardPinHandler >> After smart card login and before logoff we don't need input the PIN. This happen most possibly because that the card was replaced in the reader.");
            SmartCardPkcsKeyStore.setSmartCardActive(false);
            throw new SmartCardRuntimeError("Smart Card runtime error!");
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(new JLabel(MSGRES.getString("SmartCardPinDialog.text")));
        final JPasswordField txtPwd = new JPasswordField(20);
        panel.add(txtPwd);
        JOptionPane pane = new JOptionPane(panel, 3, 2);
        JDialog dialog = pane.createDialog(new JFrame(), MSGRES.getString("SmartCardPinDialog.title"));
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
                txtPwd.requestFocusInWindow();
            }
        });
        dialog.setVisible(true);
        int retVal = pane.getValue() != null ? (Integer)pane.getValue() : 2;
        switch (retVal) {
            case 0: {
                passCb.clearPassword();
                String pin = ((JTextComponent)txtPwd).getText();
                if (pin == null || pin.trim().length() == 0) {
                    System.out.println("SmartCardPinHandler> handlePasswordCallback>> Smart card PIN provided by user is invalid.");
                    JOptionPane.showMessageDialog(dialog, MSGRES.getString("SmartCardPinDialog.pinError"), MSGRES.getString("SmartCardPinDialog.errorTitle"), 0);
                    return 0;
                }
                passCb.setPassword(((JTextComponent)txtPwd).getText().toCharArray());
                this.password = (char[])passCb.getPassword().clone();
                ((JTextComponent)txtPwd).setText("");
                dialog.dispose();
                break;
            }
            default: {
                passCb.clearPassword();
                ((JTextComponent)txtPwd).setText("");
                System.out.println("SmartCardPinHandler> handlePasswordCallback>> Smart card PIN window is cancelled.");
                dialog.dispose();
                throw new CancellationException("-99");
            }
        }
        return 1;
    }
}

