/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.SimpleProgressDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

public class SimpleProgressPanel
extends JPanel
implements SimpleProgressDisplay {
    private static final long serialVersionUID = 1L;
    private JTextArea mText;
    private JTextArea mProgress;
    private JProgressBar mProgressBar;
    private boolean mCancelled = false;
    private JLabel mImage;

    public SimpleProgressPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(25, 25));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel north = new JPanel(new BorderLayout(15, 15));
        this.add((Component)north, "North");
        north.setOpaque(false);
        this.mText = this.createReadOnlyTextArea();
        north.add((Component)this.mText, "North");
        JPanel progressPanel = new JPanel(new BorderLayout(5, 5));
        north.add((Component)progressPanel, "South");
        progressPanel.setOpaque(false);
        this.mProgress = this.createReadOnlyTextArea();
        progressPanel.add((Component)this.mProgress, "North");
        this.mProgressBar = new JProgressBar();
        progressPanel.add((Component)this.mProgressBar, "South");
        this.mProgressBar.setIndeterminate(true);
        this.mProgressBar.setVisible(false);
        this.mImage = new JLabel();
        this.mImage.setHorizontalAlignment(0);
        this.mImage.setHorizontalTextPosition(0);
        this.mImage.setVerticalTextPosition(3);
        this.add((Component)this.mImage, "Center");
    }

    @Override
    public void cancel() {
        this.mCancelled = true;
        this.stop();
    }

    @Override
    public boolean isCancelled() {
        return this.mCancelled;
    }

    @Override
    public void setCancelEnabled(boolean b) {
    }

    @Override
    public void setCancelVisible(boolean b) {
    }

    @Override
    public void setProgressMessage(String message) {
        this.mProgress.setText(message);
    }

    @Override
    public void setText(String text) {
        this.mText.setText(text);
    }

    @Override
    public void start() {
        this.mProgressBar.setVisible(true);
    }

    @Override
    public void stop() {
        this.mProgressBar.setVisible(false);
    }

    public void setImage(Image image) {
        this.mImage.setIcon(new ImageIcon(image));
    }

    protected JTextArea createReadOnlyTextArea() {
        JTextArea text = new JTextArea();
        text.setFocusable(false);
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setFont(this.getFont());
        text.setOpaque(false);
        text.setEditable(false);
        text.setSelectionColor(this.getBackground());
        text.setSelectedTextColor(this.getForeground());
        return text;
    }

    @Override
    public void enablePercentage(HashMap<String, Integer> progressInfo) {
        if (this.mProgressBar != null) {
            this.mProgressBar.setIndeterminate(false);
            this.mProgressBar.setStringPainted(true);
        }
    }

    @Override
    public void done() {
        if (this.mProgressBar != null) {
            this.mProgressBar.setValue(100);
        }
    }
}

