/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.SimpleProgressDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class SimpleProgressDlg
extends JDialog
implements SimpleProgressDisplay {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_TEXTAREA_ROWS = 3;
    private JTextArea txtArea = new JTextArea(3, 30);
    private JProgressBar progressBar = new JProgressBar();
    private String message = "";
    private boolean isCancelled = false;
    private JTextArea progressDesc = new JTextArea(2, 40);
    private JButton cancelButton;
    private boolean bTitleBar = true;
    private HashMap<String, Integer> progressInfo = new HashMap();

    public SimpleProgressDlg(Frame frame, String title, String message, boolean modal, int rows) {
        this(frame, title, message, modal, rows, true);
    }

    public SimpleProgressDlg(Frame frame, String title, String message, boolean modal) {
        this(frame, title, message, modal, 3);
    }

    public SimpleProgressDlg(Frame frame, String title, String message, boolean modal, boolean bTitleBar) {
        this(frame, title, message, modal, 3, bTitleBar);
    }

    public SimpleProgressDlg(Frame frame, String title, String message, boolean modal, int rows, boolean bTitleBar) {
        super(frame, title, modal);
        this.txtArea.setRows(rows);
        this.message = message;
        this.setUndecorated(!bTitleBar);
        this.bTitleBar = bTitleBar;
        this.jbInit();
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        this.setLocationRelativeTo(null);
    }

    @Override
    public void setText(String text) {
        this.txtArea.setText(text);
    }

    private void jbInit() {
        JPanel descPanel = new JPanel(new GridBagLayout());
        this.txtArea.setFont(descPanel.getFont());
        this.txtArea.setText(this.message);
        this.txtArea.setColumns(40);
        this.txtArea.setEditable(false);
        this.txtArea.setWrapStyleWord(true);
        this.txtArea.setLineWrap(true);
        this.txtArea.setOpaque(false);
        this.txtArea.setBackground(this.progressBar.getBackground());
        this.txtArea.setSize(this.txtArea.getPreferredSize());
        descPanel.add((Component)this.txtArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel barPanel = new JPanel(new GridBagLayout());
        this.progressBar.setIndeterminate(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressDesc.setFont(descPanel.getFont());
        this.progressDesc.setEditable(false);
        this.progressDesc.setBackground(barPanel.getBackground());
        this.progressDesc.setWrapStyleWord(true);
        this.progressDesc.setLineWrap(true);
        this.progressDesc.setPreferredSize(this.progressDesc.getPreferredSize());
        this.progressDesc.setOpaque(false);
        this.progressDesc.setBorder(new EmptyBorder(0, 0, 0, 0));
        barPanel.add((Component)this.progressDesc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 2, 0), 0, 0));
        barPanel.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        descPanel.add((Component)barPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.cancelButton = new JButton(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "SimpleProgressDlg.btnCancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleProgressDlg.this.cancel();
            }
        });
        buttonPanel.add((Component)this.cancelButton, "East");
        this.cancelButton.setEnabled(false);
        this.cancelButton.setVisible(false);
        descPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.bTitleBar) {
            descPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 10, 20));
        } else {
            descPanel.setBorder(BorderFactory.createCompoundBorder(CustomLookAndFeel.UNDECORATED_DIALOG_BORDER, BorderFactory.createEmptyBorder(10, 30, 30, 30)));
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(descPanel);
        this.pack();
    }

    @Override
    public void setCancelVisible(boolean b) {
        this.cancelButton.setVisible(b);
    }

    @Override
    public void setCancelEnabled(boolean b) {
        this.cancelButton.setEnabled(b);
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        this.dispose();
    }

    @Override
    public void stop() {
        this.dispose();
    }

    @Override
    public void start() {
        this.setVisible(true);
    }

    @Override
    public void setProgressMessage(String pMessage) {
        this.progressDesc.setText(pMessage);
        if (this.progressInfo.containsKey(pMessage)) {
            if (this.progressBar.getValue() < this.progressInfo.get(pMessage)) {
                this.progressBar.setValue(this.progressInfo.get(pMessage));
            }
        } else {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }
    }

    @Override
    public void enablePercentage(HashMap<String, Integer> progressInfo) {
        this.progressInfo = progressInfo;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setStringPainted(true);
    }

    @Override
    public void done() {
        this.progressBar.setValue(100);
    }
}

