/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.UIColorUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class SideBarButtonUI
extends BasicRadioButtonUI {
    private boolean isRenderSelection;

    public static ComponentUI createUI(JComponent component) {
        return new SideBarButtonUI(true);
    }

    public SideBarButtonUI(boolean isRenderSelection) {
        this.isRenderSelection = isRenderSelection;
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        Dimension size = new Dimension();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font font = c.getFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        Insets i = new Insets(0, 10, 0, 0);
        size = b.getSize(size);
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = size.width - viewRect.x;
        viewRect.height = size.height - (i.bottom + viewRect.y);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        Icon icon = b.getIcon();
        boolean isMultiline = false;
        String text = null;
        if (b.getText() != null && b.getText().indexOf(10) >= 0) {
            isMultiline = true;
            JRadioButton htmlButton = this.getHtmlButton(b);
            text = SwingUtilities.layoutCompoundLabel(htmlButton, fm, htmlButton.getText(), icon, htmlButton.getVerticalAlignment(), htmlButton.getHorizontalAlignment(), htmlButton.getVerticalTextPosition(), htmlButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, htmlButton.getText() == null ? 0 : htmlButton.getIconTextGap());
        } else {
            text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        }
        if (icon != null) {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (text != null) {
            View view;
            if (isMultiline && (c.getClientProperty("html") == null || !text.equals(c.getClientProperty("old_text")))) {
                View htmlView = BasicHTML.createHTMLView(c, text);
                c.putClientProperty("html", htmlView);
                c.putClientProperty("old_text", text);
            }
            if ((view = (View)c.getClientProperty("html")) != null) {
                view.paint(g, textRect);
            } else if (model.isEnabled()) {
                if (model.isRollover()) {
                    b.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_ROLLOVER_FOREGROUND);
                } else if (this.isRenderSelection && b.isSelected() && textRect.width > 0 && textRect.height > 0) {
                    b.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_SELECTED_FOREGROUND);
                } else {
                    b.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_FOREGROUND);
                }
                this.paintText(g, b, textRect, text);
            } else {
                int mnemIndex = b.getDisplayedMnemonicIndex();
                g.setColor(UIColorUtilities.SECONDARY_NAVIGATION_DISABLED_FOREGROUND);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(b.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        }
    }

    private String getHtml(String text, boolean selected, boolean rollover) {
        int firstNewline = text.indexOf(10);
        Color foregroundColor = rollover ? UIColorUtilities.SECONDARY_NAVIGATION_ROLLOVER_FOREGROUND : (selected ? UIColorUtilities.SECONDARY_NAVIGATION_SELECTED_FOREGROUND : UIColorUtilities.SECONDARY_NAVIGATION_FOREGROUND);
        String strForegroundColor = UIColorUtilities.colorToString(foregroundColor);
        String html = "<html><body><div style='color:" + strForegroundColor + ";font-weight:bold'>" + this.escapeHtmlString(text.substring(0, firstNewline)) + "</div><div style='color:" + strForegroundColor + "'>" + this.escapeHtmlString(text.substring(firstNewline + 1)) + "</div></body></html>";
        return html;
    }

    private String escapeHtmlString(String original) {
        String html = original;
        html = html.replace("\n", "<br/>");
        html = html.replace(" ", "&nbsp;");
        return html;
    }

    private JRadioButton getHtmlButton(AbstractButton b) {
        JRadioButton htmlButton = new JRadioButton(this.getHtml(b.getText(), this.isRenderSelection && b.isSelected(), b.getModel().isRollover()));
        htmlButton.setIcon(b.getIcon());
        htmlButton.setVerticalAlignment(b.getVerticalAlignment());
        htmlButton.setHorizontalAlignment(b.getHorizontalAlignment());
        htmlButton.setVerticalTextPosition(1);
        htmlButton.setHorizontalTextPosition(b.getHorizontalTextPosition());
        htmlButton.setIconTextGap(b.getIconTextGap());
        return htmlButton;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (b.getText().indexOf(10) >= 0) {
            JRadioButton htmlButton = this.getHtmlButton(b);
            return super.getPreferredSize(htmlButton);
        }
        return super.getPreferredSize(c);
    }
}

