/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPasswordField;
import javax.swing.text.Document;

public class SEPMPasswordField
extends JPasswordField {
    private static final long serialVersionUID = 1L;

    public SEPMPasswordField() {
        this.setMouseListeners();
    }

    public SEPMPasswordField(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        this.setMouseListeners();
    }

    public SEPMPasswordField(int columns) {
        super(columns);
        this.setMouseListeners();
    }

    public SEPMPasswordField(String text) {
        super(text);
        this.setMouseListeners();
    }

    private void setMouseListeners() {
        MouseListener[] listeners;
        for (MouseListener l : listeners = this.getMouseListeners()) {
            this.removeMouseListener(l);
        }
        this.addMouseListener(new MyMouseListener(listeners));
    }

    private static class MyMouseListener
    implements MouseListener {
        private final MouseListener[] proxyListeners;

        public MyMouseListener(MouseListener[] listeners) {
            this.proxyListeners = listeners;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 && e.getButton() == 1) {
                Component comp = e.getComponent();
                if (comp instanceof JPasswordField) {
                    ((JPasswordField)comp).selectAll();
                }
            } else {
                for (MouseListener l : this.proxyListeners) {
                    l.mouseClicked(e);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            for (MouseListener l : this.proxyListeners) {
                l.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            for (MouseListener l : this.proxyListeners) {
                l.mouseExited(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() < 2 || e.getButton() != 1) {
                for (MouseListener l : this.proxyListeners) {
                    l.mousePressed(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() < 2 || e.getButton() != 1) {
                for (MouseListener l : this.proxyListeners) {
                    l.mouseReleased(e);
                }
            }
        }
    }
}

