/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.creamtec.ajaxswing.support.validation.AjaxSwingDocumentValidator;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RestrictedPlainDocument
extends PlainDocument
implements AjaxSwingDocumentValidator {
    private static final long serialVersionUID = 1L;
    private int maxCharacters;
    private boolean isAllDigit;
    private boolean allowChar = false;
    private String validator = null;

    public RestrictedPlainDocument(int maxChars) {
        this(maxChars, false);
    }

    public RestrictedPlainDocument(int maxChars, boolean isAllDigit) {
        this.maxCharacters = maxChars;
        this.isAllDigit = isAllDigit;
    }

    public void setValidator(String validator, boolean allowChar) {
        this.validator = validator;
        this.allowChar = allowChar;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            super.insertString(offs, null, a);
            return;
        }
        if (this.validator != null) {
            int i;
            char[] chars;
            if (this.allowChar) {
                chars = str.toCharArray();
                for (i = 0; i < chars.length; ++i) {
                    if (this.validator.indexOf(chars[i]) != -1) continue;
                    return;
                }
            } else {
                chars = this.validator.toCharArray();
                for (i = 0; i < chars.length; ++i) {
                    if (str.indexOf(chars[i]) == -1) continue;
                    return;
                }
            }
        }
        if (this.isAllDigit) {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (!Character.isDigit(source[i])) continue;
                result[j++] = source[i];
            }
            str = new String(result, 0, j);
        }
        if (this.getLength() + str.length() <= this.maxCharacters) {
            super.insertString(offs, str, a);
        }
    }

    public HashMap<String, Object> getParams() {
        HashMap<String, Object> validatorParams = new HashMap<String, Object>();
        validatorParams.put("name", "RestrictedPlainDocument");
        validatorParams.put("maxCharacters", this.maxCharacters);
        validatorParams.put("isAllDigit", this.isAllDigit);
        return validatorParams;
    }
}

