/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.creamtec.ajaxswing.support.validation.AjaxSwingDocumentValidator;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RestrictedPathDocument
extends PlainDocument
implements AjaxSwingDocumentValidator {
    private static final long serialVersionUID = 1L;
    public static final int MAX_PATH_CHARACTERS = 255;
    private int maxCharacters;
    private String validator = null;
    private boolean isAllowHiAscii;

    public RestrictedPathDocument(int maxCharacters) {
        this(maxCharacters, true);
    }

    private RestrictedPathDocument(int maxCharacters, boolean isAllowHiAscii) {
        this.maxCharacters = maxCharacters;
        this.isAllowHiAscii = isAllowHiAscii;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public void setAllowHiAscii(boolean isAllowHiAscii) {
        this.isAllowHiAscii = isAllowHiAscii;
    }

    public boolean isAllowHiAscii() {
        return this.isAllowHiAscii;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int i;
        char[] chars;
        if (str == null) {
            super.insertString(offs, null, a);
            return;
        }
        if (this.validator != null) {
            chars = this.validator.toCharArray();
            for (i = 0; i < chars.length; ++i) {
                if (str.indexOf(chars[i]) == -1) continue;
                return;
            }
        }
        if (!this.isAllowHiAscii) {
            chars = str.toCharArray();
            for (i = 0; i < chars.length; ++i) {
                if (!this.isHiAscii(chars[i])) continue;
                return;
            }
        }
        if (this.getLength() + str.length() <= this.maxCharacters) {
            super.insertString(offs, str, a);
        }
    }

    private boolean isHiAscii(char c) {
        return c > '\u007f' && c < '\u0100';
    }

    public HashMap<String, Object> getParams() {
        HashMap<String, Object> validatorParams = new HashMap<String, Object>();
        validatorParams.put("name", "RestrictedPathDocument");
        validatorParams.put("maxCharacters", this.maxCharacters);
        validatorParams.put("isAllDigit", false);
        return validatorParams;
    }
}

