/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.CommonUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class PopUpDialogBase
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    protected JButton jBOk = new JButton(MSG_RES.getString("com.sygate.scm.common.ui.ui", "PopUpDialogBase.ok"));
    private JButton jBCancel = new JButton(MSG_RES.getString("com.sygate.scm.common.ui.ui", "PopUpDialogBase.cancel"));
    private JButton jBHelp = new JButton(MSG_RES.getString("com.sygate.scm.common.ui.ui", "PopUpDialogBase.help"));
    private boolean isOk;

    protected PopUpDialogBase(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.setDefaultCloseOperation(2);
        KeyStroke helpKey = KeyStroke.getKeyStroke(112, 0);
        String helpActionKey = "Context-Sensitive Help";
        ((JComponent)this.getContentPane()).getInputMap(2).put(helpKey, helpActionKey);
        ((JComponent)this.getContentPane()).getActionMap().put(helpActionKey, new HelpAction());
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.isOk = false;
        }
        super.setVisible(b);
    }

    public boolean isOk() {
        return this.isOk;
    }

    protected boolean ok() {
        if (!this.isValidate()) {
            return false;
        }
        this.isOk = true;
        this.commit();
        this.dispose();
        return true;
    }

    private void cancel() {
        this.isOk = false;
        this.dispose();
    }

    private void help() {
    }

    protected void commit() {
    }

    protected boolean isValidate() {
        return true;
    }

    protected JPanel getButtonPanel() {
        return this.getButtonPanel(0, 4, true);
    }

    protected JPanel getButtonPanel(int directory, int alignment, boolean isFitButtons) {
        JPanel buttonPanel = new JPanel();
        ArrayList<JButton> buttonList = new ArrayList<JButton>();
        if (this.isOkButtonShown()) {
            buttonList.add(this.initOkButton());
        }
        if (this.isCancelButtonShown()) {
            buttonList.add(this.initCancelButton());
        }
        if (this.isHelpButtonShown()) {
            buttonList.add(this.initHelpButton());
        }
        CommonUtilities.layoutButtonPanel(buttonPanel, buttonList.toArray(new JButton[0]), directory, alignment, isFitButtons);
        this.jBOk.setEnabled(this.isOkButtonActive());
        UiUtilities.setDefaultButton(this, this.jBOk);
        return buttonPanel;
    }

    protected boolean isOkButtonActive() {
        return true;
    }

    protected boolean isOkButtonShown() {
        return true;
    }

    protected boolean isCancelButtonShown() {
        return true;
    }

    private boolean isHelpButtonShown() {
        return false;
    }

    protected String getOkButtonText() {
        return null;
    }

    private String getCancelButtonText() {
        return null;
    }

    private String getHelpButtonText() {
        return null;
    }

    private JButton initOkButton() {
        this.jBOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpDialogBase.this.ok();
            }
        });
        String okText = this.getOkButtonText();
        if (okText != null) {
            this.jBOk.setText(okText);
        }
        return this.jBOk;
    }

    private JButton initCancelButton() {
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpDialogBase.this.cancel();
            }
        });
        String cancelText = this.getCancelButtonText();
        if (cancelText != null) {
            this.jBCancel.setText(cancelText);
        }
        return this.jBCancel;
    }

    private JButton initHelpButton() {
        this.jBHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpDialogBase.this.help();
            }
        });
        String helpText = this.getHelpButtonText();
        if (helpText != null) {
            this.jBHelp.setText(helpText);
        }
        return this.jBHelp;
    }

    private class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopUpDialogBase.this.help();
        }
    }
}

