/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.configobject.schema.PasswordSettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.PasswordSettingsHelper;
import com.sygate.scm.common.ui.PasswordStrengthChecker;
import com.sygate.scm.common.ui.UIColorUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class PasswordWidget
extends JPanel {
    private static final long serialVersionUID = -5233260075015561986L;
    private JProgressBar monitor = null;
    private static final MessageResources MSG = MessageResources.getInstance();
    private final String strengthLabel = MSG.getString("com.sygate.scm.common.ui.ui", "PasswordWidget.textLabel");
    private final JLabel textLabel = new JLabel(this.strengthLabel, 4);
    private final JLabel statusLabel = new JLabel();
    private PasswordStrengthChecker.Strength passwordStrength = PasswordStrengthChecker.Strength.WEAK;
    private boolean horizontal;
    private boolean fullWidth;

    public PasswordWidget() {
        this(true);
    }

    public PasswordWidget(boolean horizontal) {
        this(horizontal, true);
    }

    public PasswordWidget(boolean horizontal, boolean fullWidth) {
        this.horizontal = horizontal;
        this.fullWidth = fullWidth;
        this.initialize();
    }

    private void initialize() {
        if (this.horizontal) {
            this.setLayout(new BorderLayout(2, 0));
            this.add((Component)this.textLabel, "West");
            this.add(this.getMonitor(), "East");
        } else {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.textLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.getMonitor(), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.getStatus(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private Component getMonitor() {
        if (this.monitor == null) {
            this.monitor = new JProgressBar();
            this.monitor.setStringPainted(false);
            if (!this.fullWidth) {
                this.monitor.setPreferredSize(new Dimension(this.monitor.getPreferredSize().width / 3, this.monitor.getPreferredSize().height));
            }
        }
        return this.monitor;
    }

    private Component getStatus() {
        return this.statusLabel;
    }

    public void analyzeStrength(char[] pwd) {
        this.analyzeStrength(pwd, true);
    }

    public void analyzeStrength(char[] pwd, PasswordSettings settings) {
        boolean isValidPwd = PasswordSettingsHelper.checkRequirements(settings, pwd) == 0;
        this.analyzeStrength(pwd, isValidPwd);
    }

    public void analyzeStrength(char[] pwd, boolean isValidPwd) {
        int score = 0;
        if (isValidPwd && PasswordStrengthChecker.Strength.NOT_ACCEPTABLE == PasswordStrengthChecker.valueOf(score = PasswordStrengthChecker.getPasswordStrength(pwd))) {
            score = PasswordStrengthChecker.Strength.WEAK.getScore();
        }
        this.setPasswordStrength(PasswordStrengthChecker.valueOf(score));
        this.monitor.setValue(score);
        this.updateStatus();
    }

    private void updateStatus() {
        Object status = "";
        PasswordStrengthChecker.Strength currentStrength = this.getPasswordStrength();
        switch (currentStrength) {
            case VERY_STRONG: {
                status = MSG.getString("com.sygate.scm.common.ui.ui", "PasswordWidget.veryStrong");
                this.monitor.setForeground(UIColorUtilities.SUCCESS_BACKGROUND);
                break;
            }
            case STRONG: {
                status = MSG.getString("com.sygate.scm.common.ui.ui", "PasswordWidget.strong");
                this.monitor.setForeground(UIColorUtilities.SUCCESS_BACKGROUND);
                break;
            }
            case GOOD: {
                status = MSG.getString("com.sygate.scm.common.ui.ui", "PasswordWidget.good");
                this.monitor.setForeground(UIColorUtilities.WARNING_BACKGROUND);
                break;
            }
            case WEAK: {
                status = MSG.getString("com.sygate.scm.common.ui.ui", "PasswordWidget.weak");
                this.monitor.setForeground(UIColorUtilities.ERROR_BACKGROUND);
                break;
            }
            default: {
                status = MSG.getString("com.sygate.scm.common.ui.ui", "PasswordWidget.notAcceptable");
                this.monitor.setValue(100);
                this.monitor.setForeground(UIColorUtilities.ERROR_BACKGROUND);
            }
        }
        status = " " + (String)status;
        if (this.horizontal) {
            this.textLabel.setText(this.strengthLabel + (String)status);
            this.textLabel.revalidate();
        } else {
            this.statusLabel.setText((String)status);
            this.statusLabel.revalidate();
        }
    }

    public PasswordStrengthChecker.Strength getPasswordStrength() {
        return this.passwordStrength;
    }

    public void setPasswordStrength(PasswordStrengthChecker.Strength passwordStrength) {
        this.passwordStrength = passwordStrength;
    }

    @Override
    public void setEnabled(boolean tf) {
        this.monitor.setEnabled(tf);
        this.monitor.setVisible(tf);
        this.statusLabel.setEnabled(tf);
        this.textLabel.setVisible(tf);
    }
}

