/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

public final class PasswordStrengthChecker {
    private static final String ALPHAS = "abcdefghijklmnopqrstuvwxyz";
    private static final String NUMERICS = "01234567890";
    private static final int MULT_LENGTH = 2;
    private static final int MULT_UPPER = 2;
    private static final int MULT_LOWER = 2;
    private static final int MULT_NUMBER = 2;
    private static final int MULT_SYMBOL = 2;
    private static final int MULT_MIDCHAR = 2;
    private static final int MULT_TYPES = 4;
    private static final int NOT_ACCEPTABLE_LIMIT = 0;
    private static final int WEAK_LIMIT = 40;
    private static final int GOOD_LIMIT = 60;
    private static final int STRONG_LIMIT = 80;
    private static final int VERY_STRONG_LIMIT = 100;
    private static final int WARNING_MIN_PASSWORD_LENGTH = 8;
    private static final int MIN_CHAR_TYPES = 4;

    public static synchronized int getPasswordStrength(char[] password) {
        int score = -1;
        int pwdLength = 0;
        int alphaUc = 0;
        int alphaLc = 0;
        int number = 0;
        int symbol = 0;
        int midChar = 0;
        int repChar = 0;
        int seqAlpha = 0;
        int seqNumber = 0;
        int types = 0;
        StringBuffer repChars = new StringBuffer();
        if (password != null && password.length > 0) {
            String fwd;
            StringBuffer passwordStr = new StringBuffer();
            passwordStr.append(password);
            pwdLength = password.length;
            score = pwdLength * 2;
            for (int i = 0; i < pwdLength; ++i) {
                if (password[i] >= 'A' && password[i] <= 'Z') {
                    ++alphaUc;
                } else if (password[i] >= 'a' && password[i] <= 'z') {
                    ++alphaLc;
                } else if (password[i] >= '0' && password[i] <= '9') {
                    if (i > 0 && i < pwdLength - 1) {
                        ++midChar;
                    }
                    ++number;
                } else {
                    if (i > 0 && i < pwdLength - 1) {
                        ++midChar;
                    }
                    ++symbol;
                }
                for (int j = i + 1; j < pwdLength; ++j) {
                    if (Character.toLowerCase(password[i]) != Character.toLowerCase(password[j]) || repChars.toString().indexOf(Character.toLowerCase(password[i])) != -1) continue;
                    String temp = passwordStr.substring(j).toLowerCase();
                    int index = temp.indexOf(Character.toLowerCase(password[i]));
                    if (index != -1) {
                        ++repChar;
                        while (index != -1) {
                            ++repChar;
                            temp = temp.substring(index + 1);
                            index = temp.indexOf(Character.toLowerCase(password[i]));
                        }
                    }
                    repChars.append(Character.toLowerCase(password[i]));
                }
            }
            for (int i1 = 0; i1 < passwordStr.length(); ++i1) {
                passwordStr.setCharAt(i1, '0');
            }
            StringBuffer lowerCasePasswordStr = new StringBuffer();
            for (int i = 0; i < password.length; ++i) {
                lowerCasePasswordStr.append(Character.toLowerCase(password[i]));
            }
            for (int k = 0; k < 23; ++k) {
                fwd = ALPHAS.substring(k, k + 3);
                String rev = new StringBuffer(fwd).reverse().toString();
                if (lowerCasePasswordStr.indexOf(fwd) == -1 && lowerCasePasswordStr.indexOf(rev) == -1) continue;
                ++seqAlpha;
            }
            for (int s = 0; s < 8; ++s) {
                fwd = NUMERICS.substring(s, s + 3);
                String rev = new StringBuffer(fwd).reverse().toString();
                if (lowerCasePasswordStr.indexOf(fwd) == -1 && lowerCasePasswordStr.indexOf(rev) == -1) continue;
                ++seqNumber;
            }
            for (int i1 = 0; i1 < lowerCasePasswordStr.length(); ++i1) {
                lowerCasePasswordStr.setCharAt(i1, '0');
            }
            if (alphaUc > 0 && alphaUc <= pwdLength) {
                score += alphaUc * 2;
                ++types;
            }
            if (alphaLc > 0 && alphaLc <= pwdLength) {
                score += alphaLc * 2;
                ++types;
            }
            if (number > 0 && number <= pwdLength) {
                score += number * 2;
                ++types;
            }
            if (symbol > 0) {
                score += symbol * 2;
                ++types;
            }
            if (midChar > 0) {
                score += midChar * 2;
            }
            score += types * 4;
            if (pwdLength - repChar + repChars.length() < 3) {
                score -= 15;
            }
            if (pwdLength < 8) {
                score = 0;
            }
            if (types < 4) {
                score = 0;
            }
            if ((alphaLc > 0 || alphaUc > 0) && symbol == 0 && number == 0) {
                score = 0;
            }
            if (alphaLc == 0 && alphaUc == 0 && symbol == 0 && number > 0) {
                score = 0;
            }
            if (repChar > 0) {
                score -= repChar;
            }
            if (seqAlpha > 0) {
                score -= seqAlpha;
            }
            if (seqNumber > 0) {
                score -= seqNumber;
            }
            if (score > 100) {
                score = 100;
            } else if (score < 0) {
                score = 0;
            }
        }
        return score;
    }

    public static Strength valueOf(int score) {
        if (score < 40) {
            return Strength.NOT_ACCEPTABLE;
        }
        if (score < 60) {
            return Strength.WEAK;
        }
        if (score < 80) {
            return Strength.GOOD;
        }
        if (score < 100) {
            return Strength.STRONG;
        }
        return Strength.VERY_STRONG;
    }

    public static enum Strength {
        NOT_ACCEPTABLE(0),
        WEAK(40),
        GOOD(60),
        STRONG(80),
        VERY_STRONG(100);

        private int score;

        private Strength(int score) {
            this.score = score;
        }

        public int getScore() {
            return this.score;
        }
    }
}

