/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.configobject.schema.PasswordSettings;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Pattern;

public class PasswordSettingsHelper {
    private static final Pattern uppercaseRegEx = Pattern.compile("[A-Z]");
    private static final Pattern lowercaseRegEx = Pattern.compile("[a-z]");
    private static final Pattern digitsRegEx = Pattern.compile("[0-9]");
    private static final Pattern specialRegEx = Pattern.compile("[^a-z0-9 ]", 2);
    private static MessageResourcesFile messageResource = new MessageResourcesFile("com.sygate.scm.common.ui.ui");
    public static final int PASSWORD_VALID = 0;
    public static final int PASSWORD_TOO_SHORT = 1;
    public static final int PASSWORD_TOO_LONG = 2;
    public static final int PASSWORD_MISSING_UPPERCASE = 4;
    public static final int PASSWORD_MISSING_LOWERCASE = 8;
    public static final int PASSWORD_MISSING_DIGITS = 16;
    public static final int PASSWORD_MISSING_SPECIAL = 32;

    private PasswordSettingsHelper() {
    }

    public static int checkRequirements(PasswordSettings settings, char[] password) {
        int result = 0;
        StringBuilder passwordStr = new StringBuilder();
        passwordStr.append(password);
        if (passwordStr.length() < Optional.ofNullable(settings.getOptMinCharacters()).orElse(settings.getDefMinCharacters())) {
            result |= 1;
        }
        if (passwordStr.length() > Optional.ofNullable(settings.getOptMaxCharacters()).orElse(settings.getDefMaxCharacters())) {
            result |= 2;
        }
        if (Optional.ofNullable(settings.getOptUppercase()).orElse(settings.getDefUppercase()).booleanValue() && !uppercaseRegEx.matcher(passwordStr).find()) {
            result |= 4;
        }
        if (Optional.ofNullable(settings.getOptLowercase()).orElse(settings.getDefLowercase()).booleanValue() && !lowercaseRegEx.matcher(passwordStr).find()) {
            result |= 8;
        }
        if (Optional.ofNullable(settings.getOptDigits()).orElse(settings.getDefDigits()).booleanValue() && !digitsRegEx.matcher(passwordStr).find()) {
            result |= 0x10;
        }
        if (Optional.ofNullable(settings.getOptSpecial()).orElse(settings.getDefSpecial()).booleanValue() && !specialRegEx.matcher(passwordStr).find()) {
            result |= 0x20;
        }
        for (int i = 0; i < passwordStr.length(); ++i) {
            passwordStr.setCharAt(i, '0');
        }
        return result;
    }

    public static String getPasswordErrorMessages(PasswordSettings settings, int passwordValidity, boolean useHtml) {
        Integer minCharacters;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if ((passwordValidity & 1) == 1) {
            minCharacters = Optional.ofNullable(settings.getOptMinCharacters()).orElse(settings.getDefMinCharacters());
            errorMessages.add(MessageFormat.format(messageResource.getString("PasswordSettingsHelper.tooshort.error"), minCharacters));
        }
        if ((passwordValidity & 2) == 2) {
            minCharacters = Optional.ofNullable(settings.getOptMaxCharacters()).orElse(settings.getDefMaxCharacters());
            errorMessages.add(MessageFormat.format(messageResource.getString("PasswordSettingsHelper.toolong.error"), minCharacters));
        }
        if ((passwordValidity & 4) == 4) {
            errorMessages.add(messageResource.getString("PasswordSettingsHelper.missinguppercase.error"));
        }
        if ((passwordValidity & 8) == 8) {
            errorMessages.add(messageResource.getString("PasswordSettingsHelper.missinglowercase.error"));
        }
        if ((passwordValidity & 0x10) == 16) {
            errorMessages.add(messageResource.getString("PasswordSettingsHelper.missingdigits.error"));
        }
        if ((passwordValidity & 0x20) == 32) {
            errorMessages.add(messageResource.getString("PasswordSettingsHelper.missingspecial.error"));
        }
        StringBuilder message = new StringBuilder();
        String separator = System.getProperty("line.separator");
        if (useHtml) {
            separator = "<BR>";
        }
        if (!errorMessages.isEmpty()) {
            for (String errorMessage : errorMessages) {
                message.append(errorMessage).append(separator);
            }
            if (useHtml) {
                message.insert(0, "<HTML>");
                message.append("</HTML>");
            }
        }
        return message.toString();
    }
}

