/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.UIColorUtilities;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class OutlookButtonUI
extends MetalToggleButtonUI {
    public static ComponentUI createUI(JComponent component) {
        return new OutlookButtonUI();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        JToggleButton tb = (JToggleButton)c;
        JToggleButton.ToggleButtonModel tbm = (JToggleButton.ToggleButtonModel)tb.getModel();
        int width = tb.getWidth();
        int height = tb.getHeight();
        if (tbm.isRollover()) {
            g.setColor(UIColorUtilities.MAIN_NAVIGATION_BACKGROUND);
        } else if (tbm.isSelected()) {
            g.setColor(UIColorUtilities.MAIN_NAVIGATION_SELECTED);
        } else {
            g.setColor(UIColorUtilities.SECONDARY_NAVIGATION_BACKGROUND);
        }
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(UIColorUtilities.CONTROL_BACKGROUND);
        g.drawRect(0, 0, width - 1, height - 1);
        if (tbm.isSelected() && !tbm.isRollover()) {
            g.setColor(UIColorUtilities.MAIN_NAVIGATION_SELECTED_FOREGROUND);
        } else {
            g.setColor(UIColorUtilities.MAIN_NAVIGATION_FOREGROUND);
        }
        FontMetrics metrics = g.getFontMetrics();
        int f_height = metrics.getHeight();
        g.drawString(tb.getText(), 10, (height + f_height - 5) / 2);
    }
}

