/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.creamtec.ajaxswing.support.validation.AjaxSwingDocumentValidator;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberPlainDocument
extends PlainDocument
implements AjaxSwingDocumentValidator {
    private static final long serialVersionUID = 1L;
    private long max;
    private boolean isPositive;

    public NumberPlainDocument() {
        this(Integer.MAX_VALUE, false);
    }

    public NumberPlainDocument(long max, boolean isPositive) {
        this.max = max;
        this.isPositive = isPositive;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            super.insertString(offs, str, a);
            return;
        }
        if (this.isPositive && str.charAt(0) == '-') {
            return;
        }
        try {
            String text = this.getText(0, this.getLength());
            long i = Long.parseLong(text.substring(0, offs) + str + text.substring(offs));
            if (i <= this.max) {
                int pos;
                super.insertString(offs, str, a);
                text = this.getText(0, this.getLength());
                for (pos = 0; pos < this.getLength() - 1 && '0' == text.charAt(pos); ++pos) {
                }
                this.remove(0, pos);
            }
        }
        catch (RuntimeException e) {
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    public long getMax() {
        return this.max;
    }

    public HashMap<String, Object> getParams() {
        HashMap<String, Object> validatorParams = new HashMap<String, Object>();
        validatorParams.put("name", "NumberPlainDocument");
        validatorParams.put("min", 0);
        validatorParams.put("max", this.max);
        validatorParams.put("isPositive", this.isPositive);
        return validatorParams;
    }
}

