/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.UIColorUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class NavigateButtonUI
extends MetalButtonUI {
    public static ComponentUI createUI(JComponent component) {
        return new NavigateButtonUI();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Color oldPaint = g.getColor();
        JButton b = (JButton)c;
        ButtonModel model = b.getModel();
        int w = c.getWidth();
        int h = c.getHeight();
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, w, h);
            if (model.isSelected()) {
                g.setColor(UIColorUtilities.MAIN_NAVIGATION_SELECTED);
                g.fillRect(0, 0, w, h);
            }
            g.setColor(oldPaint);
        }
        if (model.isRollover()) {
            g.setColor(UIColorUtilities.MAIN_NAVIGATION_ROLLOVER);
            g.fillRect(0, 0, w, h);
            g.setColor(oldPaint);
        }
        if (model.isSelected() && !model.isRollover()) {
            b.setForeground(UIColorUtilities.MAIN_NAVIGATION_SELECTED_FOREGROUND);
        } else {
            b.setForeground(UIColorUtilities.MAIN_NAVIGATION_FOREGROUND);
        }
        this.paint(g, c);
    }

    @Override
    public void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    public void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        JButton b = (JButton)c;
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (model.isPressed() && model.isArmed()) {
            icon.paintIcon(c, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }
}

