/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.LineNumberReader;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MultiLineMsgBox {
    private NarrowOptionPane optionPane = new NarrowOptionPane();
    private Component parent = null;
    private String title = null;

    private MultiLineMsgBox(Component parent, String title) {
        this.parent = parent;
        this.title = title;
    }

    private int getOptionValue() {
        Object value = this.optionPane.getValue();
        if (value == null || !(value instanceof Integer)) {
            return -1;
        }
        return (Integer)value;
    }

    public void init(String msg, int maxCharactersPerLineCount, int messageType, int optionType) {
        this.init(msg, maxCharactersPerLineCount, messageType, optionType, 8);
    }

    public void init(String msg, int maxCharactersPerLineCount, int messageType, int optionType, int maxLinesCanBeDisplayed) {
        this.optionPane.setMaxCharactersPerLineCount(maxCharactersPerLineCount);
        this.optionPane.setMessageType(messageType);
        this.optionPane.setOptionType(optionType);
        this.setMultiLineMessage(msg, maxCharactersPerLineCount, maxLinesCanBeDisplayed);
    }

    private void setMultiLineMessage(String msg, int maxCharactersPerLine, int maxLinesCanBeDisplayed) {
        int lineCount = 0;
        int totalCharCount = msg.length();
        LineNumberReader line = new LineNumberReader(new StringReader(msg));
        try {
            while (line.readLine() != null) {
                ++lineCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lineCount > maxLinesCanBeDisplayed || totalCharCount / maxCharactersPerLine >= maxLinesCanBeDisplayed || lineCount == 1 && totalCharCount > maxCharactersPerLine) {
            int noOfRowsToBeDisplayed = totalCharCount / maxCharactersPerLine;
            if (totalCharCount % maxCharactersPerLine > 0) {
                ++noOfRowsToBeDisplayed;
            }
            noOfRowsToBeDisplayed = Math.max(lineCount, noOfRowsToBeDisplayed);
            noOfRowsToBeDisplayed = Math.min(noOfRowsToBeDisplayed, maxLinesCanBeDisplayed);
            this.setMultiLineTextAreaToOptionPane(msg, noOfRowsToBeDisplayed);
        } else {
            Object[] objs = new Object[]{msg};
            this.optionPane.setMessage(objs);
        }
    }

    private void setMultiLineTextAreaToOptionPane(String msg, int noOfRowsToBeDisplayed) {
        JTextArea mLineMsgTextArea = new JTextArea();
        mLineMsgTextArea.setRows(noOfRowsToBeDisplayed);
        mLineMsgTextArea.setBorder(BorderFactory.createEmptyBorder());
        mLineMsgTextArea.setBackground(this.optionPane.getBackground());
        mLineMsgTextArea.setFont(this.optionPane.getFont());
        mLineMsgTextArea.setLineWrap(true);
        mLineMsgTextArea.setWrapStyleWord(true);
        mLineMsgTextArea.setEditable(false);
        mLineMsgTextArea.setText(msg.trim());
        mLineMsgTextArea.setCaretPosition(0);
        JScrollPane mLineMsgTextScrollPane = new JScrollPane(mLineMsgTextArea);
        mLineMsgTextScrollPane.setBorder(BorderFactory.createEmptyBorder());
        Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
        int minimumOptionPaneWidth = 300;
        int scrollPaneWidth = Math.max(minimumOptionPaneWidth, screenResolution.width / 3);
        this.optionPane.setMessage(mLineMsgTextScrollPane);
        this.optionPane.setPreferredSize(new Dimension(scrollPaneWidth, this.optionPane.getPreferredSize().height));
    }

    private int show() {
        JDialog dlg = this.optionPane.createDialog(this.parent, this.title);
        dlg.setVisible(true);
        return this.getOptionValue();
    }

    public static int show(Component parent, String title, String message, int maxCharactersPerLineCount, int messageType, int optionType) {
        MultiLineMsgBox box = new MultiLineMsgBox(parent, title);
        box.init(message, maxCharactersPerLineCount, messageType, optionType);
        return box.show();
    }

    private static class NarrowOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = 1L;
        int maxCharsPerLineCount = 0;

        public void setMaxCharactersPerLineCount(int maxCharsPerLineCount) {
            this.maxCharsPerLineCount = maxCharsPerLineCount;
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return this.maxCharsPerLineCount > 0 ? this.maxCharsPerLineCount : super.getMaxCharactersPerLineCount();
        }
    }
}

