/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.MaxMemoryLink;
import com.sygate.scm.common.ui.PopUpDialogBase;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.CommonUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MemoryWarningDialog
extends PopUpDialogBase {
    private static final long serialVersionUID = -1235977932059049615L;
    private JFrame parent = null;
    private JCheckBox cbx = null;
    private boolean isShowCheckBox = false;
    private static boolean hasShown = false;

    public MemoryWarningDialog(JFrame parent, Integer value) {
        this(parent, value, false);
    }

    private MemoryWarningDialog(JFrame parent, Integer value, boolean isShowCheckBox) {
        super(parent, parent.getTitle(), true);
        this.parent = parent;
        this.isShowCheckBox = isShowCheckBox;
        this.init(value);
        this.pack();
        CommonUtilities.centerDlg(this);
        this.setResizable(false);
        this.setFocusable(true);
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (hasShown) {
            super.setVisible(false);
        } else {
            super.setVisible(isVisible);
        }
    }

    private void init(Integer value) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)new JLabel("", UIManager.getIcon("OptionPane.informationIcon"), 10), new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 2, new Insets(0, 15, 0, 5), 0, 0));
        this.getContentPane().add((Component)new MaxMemoryLink(this.parent, value), new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getCheckBoxPanel(), new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    private JPanel getCheckBoxPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setFont(this.parent.getFont());
        buttonPanel.setLayout(new BorderLayout());
        if (this.isShowCheckBox) {
            this.cbx = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "MemoryWarningDialog.dontShowAgain"));
            this.cbx.setSelected(false);
            this.cbx.setOpaque(false);
            this.cbx.setFont(this.parent.getFont());
            this.cbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    hasShown = MemoryWarningDialog.this.cbx.isSelected();
                }
            });
            buttonPanel.add((Component)this.cbx, "Center");
        }
        return buttonPanel;
    }

    @Override
    protected boolean isCancelButtonShown() {
        return false;
    }

    @Override
    protected JPanel getButtonPanel() {
        return this.getButtonPanel(0, 0, true);
    }

    @Override
    protected JPanel getButtonPanel(int directory, int alignment, boolean isFitButtons) {
        JPanel buttonPanel = new JPanel();
        ArrayList<JButton> buttonList = new ArrayList<JButton>();
        if (this.isOkButtonShown()) {
            buttonList.add(this.initOkButton());
        }
        CommonUtilities.layoutButtonPanel(buttonPanel, buttonList.toArray(new JButton[0]), directory, alignment, isFitButtons);
        this.jBOk.setEnabled(this.isOkButtonActive());
        UiUtilities.setDefaultButton(this, this.jBOk);
        return buttonPanel;
    }

    @Override
    protected String getOkButtonText() {
        return MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "MemoryWarningDialog.OK");
    }

    private JButton initOkButton() {
        this.jBOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryWarningDialog.this.ok();
            }
        });
        String okText = this.getOkButtonText();
        if (okText != null) {
            this.jBOk.setText(okText);
        }
        return this.jBOk;
    }
}

