/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MaxMemoryLink
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1116667214684461945L;
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.common.ui.ui");
    private Component parent;
    private Integer value = null;

    public MaxMemoryLink(Component parent, Integer value) {
        this.value = value;
        this.init(parent);
    }

    private void init(Component parent) {
        this.parent = parent;
        this.setOpaque(false);
        this.setBorder(null);
        this.setFont(parent.getFont());
        this.setBackground(parent.getBackground());
        this.setLayout(new GridBagLayout());
        this.initMemoryLink();
        this.setFocusable(false);
    }

    private void initMemoryLink() {
        JLabel prefix = new JLabel(this.getLinkPrefix());
        prefix.setFont(this.parent.getFont().deriveFont(1));
        prefix.setFocusable(false);
        prefix.setBackground(this.parent.getBackground());
        this.add((Component)prefix, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        JLabel content = new JLabel(this.getLinkContent());
        content.setFocusable(false);
        content.setFont(this.parent.getFont());
        content.setBackground(this.parent.getBackground());
        this.add((Component)content, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        JLabel link = new JLabel("<html><body><u>" + this.getLinkText() + "</u></body></html>");
        link.setCursor(Cursor.getPredefinedCursor(12));
        link.setForeground(Color.BLUE);
        link.setFocusable(false);
        link.setFont(this.parent.getFont());
        link.setBackground(this.parent.getBackground());
        link.setOpaque(false);
        link.setToolTipText(this.getTargetURL());
        this.add((Component)link, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                URLUtility.showURL(MaxMemoryLink.this.getTargetURL());
            }
        });
    }

    protected String getTargetURL() {
        return MessageFormat.format(MSGRES.getString("MaxMemoryLink.url"), ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage());
    }

    protected String getLinkText() {
        return MSGRES.getString("MaxMemoryLink.LinkText");
    }

    protected String getLinkContent() {
        String retMsg = null;
        retMsg = this.value == null ? MSGRES.getString("MaxMemoryLink.Content") : MessageFormat.format(MSGRES.getString("MaxMemoryLink.ContentValue"), this.value);
        return retMsg;
    }

    protected String getLinkPrefix() {
        return MSGRES.getString("MaxMemoryLink.LinkPrefix");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        URLUtility.showURL(this.getTargetURL());
    }
}

