/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.ImagePanel;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.ProgressListener;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class LoadingScreen
extends JDialog
implements ProgressListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar = new JProgressBar();
    private static final MessageResourcesFile RES = new MessageResourcesFile("com.sygate.scm.common.ui.ui");

    public LoadingScreen(String backgroundImagePath) {
        JPanel basePanel = new JPanel(new BorderLayout());
        JLayeredPane centerPanel = this.getCenterPanel(backgroundImagePath);
        basePanel.add((Component)centerPanel, "Center");
        basePanel.add((Component)this.progressBar, "South");
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setUndecorated(true);
        this.add(basePanel);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.pack();
        UiUtilities.centerComponent(this);
    }

    private JPanel getImagePanel(String backgroundImagePath) {
        ImagePanel imagePanel = new ImagePanel(null, backgroundImagePath, false);
        JLabel label = new JLabel(RES.getString("LoadingScreen.loading"));
        imagePanel.setLayout(new GridBagLayout());
        imagePanel.add((Component)label, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 16, 0, new Insets(10, 10, 10, 10), 0, 0));
        return imagePanel;
    }

    private JTextPane getTextPanelInImage() {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setOpaque(false);
        textPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        StyledDocument doc = textPane.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        String fontName = UIFontUtilities.STANDARD_FONT_NAME;
        StyleConstants.setFontFamily(def, fontName);
        Style s = doc.addStyle("fontSize", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontSize(s, UIFontUtilities.LOADING_SCREEN_FONT_SIZE);
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        String managementconfigWizard = RES.getString("LoadingScreen.MSCW");
        try {
            doc.insertString(doc.getLength(), managementconfigWizard, doc.getStyle("fontSize"));
        }
        catch (BadLocationException e) {
            LoggerUtilities.logException(e);
        }
        return textPane;
    }

    private JLayeredPane getCenterPanel(String backgroundImagePath) {
        JLayeredPane lPane = new JLayeredPane();
        JPanel imagePanel = this.getImagePanel(backgroundImagePath);
        JTextPane textPane = this.getTextPanelInImage();
        ImageIcon wizardIcon = new ImageIcon(MessageResources.getImage(backgroundImagePath));
        imagePanel.setBounds(0, 0, wizardIcon.getIconWidth(), wizardIcon.getIconHeight());
        lPane.add((Component)imagePanel, JLayeredPane.DEFAULT_LAYER);
        lPane.add((Component)textPane, JLayeredPane.PALETTE_LAYER);
        imagePanel.setBounds(0, 0, wizardIcon.getIconWidth(), wizardIcon.getIconHeight());
        String left = RES.getString("LoadingScreen.MSCW.left");
        String top = RES.getString("LoadingScreen.MSCW.top");
        int leftValue = 60;
        int topValue = 190;
        try {
            leftValue = Integer.parseInt(left);
            topValue = Integer.parseInt(top);
        }
        catch (NumberFormatException e) {
            LoggerUtilities.logException(e);
        }
        textPane.setBounds(leftValue, topValue, textPane.getPreferredSize().width, textPane.getPreferredSize().height);
        Dimension paneSize = imagePanel.getPreferredSize();
        lPane.setPreferredSize(paneSize);
        lPane.setMinimumSize(paneSize);
        lPane.setMaximumSize(paneSize);
        return lPane;
    }

    @Override
    public void setPercentComplete(int percentComplete) {
        this.progressBar.setValue(percentComplete);
    }

    public int getPercentComplete() {
        return this.progressBar.getValue();
    }
}

